package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** 
 * Klasse stellt latente Variable Theta dar,
 * @author Andreas Sitta
 * @version 1.0
 *
 */
public class Theta implements Comparable<Theta>{
	int topic;
	int community;
	double prob;
	
	public Theta(int community, int topic, Double prob){
		this.topic=topic;
		this.community=community;
		this.prob=prob;
	}
	
	@Override
	public int compareTo(Theta delta) {
		return Double.compare(this.prob, delta.prob);
	}
}