package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

/** Diese Klasse stellt Routinen zur Verfügung die gewonnenen Daten (latente Variablen) unter verschiedenen Gesichtspunkten in Dateien auszugeben.
 * @author Andreas Sitta
 * @version 1.0
 *
*/
public class Part4DataConverter {
	static double[][] phiLink;
	static double[][] thetaLink;
	static double[][] psiLink;
	static double[][] deltaLink;
	static double[][] phiLDA;
	static double[] divLDA;
	static ArrayList<Phi> phiListLink = new ArrayList<Phi>();
	static ArrayList<Phi>[] phiTopicWords;
	static ArrayList<Delta> deltaListLink = new ArrayList<Delta>();
	static ArrayList<Delta>[] deltaUsersCom, deltaComUser;
	static ArrayList<Theta> thetaListLink = new ArrayList<Theta>();
	static ArrayList<Theta>[] thetaComTopic, thetaTopicCom;
    static ArrayList<Psi> psiListLink = new ArrayList<Psi>();
    static ArrayList<Psi>[] psiComUsers, psiUsersCom;
	static ArrayList<Phi> phiListLDA = new ArrayList<Phi>();
    static ArrayList<Phi>[] phiTopicWord;
	static String phiWordTopicString[][], deltaUserComString[][], psiComUserString[][];
	static double phiWordTopicProb[][], deltaUserComProb[][], psiComUserProb[][]; 
	

    static BufferedWriter bS, bT, bE, bX, bW4;
    static ArrayList<User> users;
    static Gson gson;
	static String p2, fileID = "", dataName = "", dName = "", pName = "";
	static ArrayList<String> vocabulary; 
	static ArrayList<String> userNames; 
	
	static boolean divF = true; 
	
	/**
	 * Main Routine
	 * @param args derzeit nicht verwendet
	 * @throws IOException
	 */
    public static void main(String[] args) throws IOException{
		// Part3 und projectbezogenen Pfad lesen / Dateinamen für Protokolle festlegen.
		getFileN("output/Part3.txt");
		pName+= "-df"+divF;
		dName = "output/"+dataName+"/"+pName+"/";
		
		fileID="Test";
		
		// Verzeichnisse prüfen und anlegen.
		File f = new File("output"); //Verzeichnis erstellen wenn noch nicht da
		if (! f.exists()) f.mkdir();
		f = new File("output/"+dataName); 
		if (! f.exists()) f.mkdir();
		f = new File(dName); 
		if (! f.exists()) f.mkdir();
			
		// Protokoll von Part 3 in BaseReport (datum/zeit) kopieren
		MyTools.copyFile("output/Part3.txt",dName+fileID+"-BaseReport.txt", pName);
		bW4 = new BufferedWriter(new FileWriter(dName+fileID+"-BaseReport.txt", true));
		bW4.write("\r\n\r\n**********************************   Part 4   ****************************************\r\n\r\n");

		
		gson = new Gson();
		vocabulary = gson.fromJson(new FileReader("1vocabulary.json"), new TypeToken<ArrayList<String>>() {}.getType());
		users = gson.fromJson(new FileReader("2users.json"), new TypeToken<ArrayList<User>>() {}.getType());
		userNames = new ArrayList<String>();
		for(int u=0;u<users.size();u++) 	userNames.add( users.get(u).name );
		
		linkContent();	
		
		bW4.close();
		System.out.println("ENDE!!!");
	}
	
	/**
	 * Eigentliche Sortier- und Ausgaberoutine
	 * @throws IOException
	 */
	public static void linkContent() throws IOException{
		System.out.println("Daten einlesen");
		gson = new Gson();
		//lese latente Variablen
		Reader fr = new FileReader("3latent.json");
		LatentVariables vars = gson.fromJson(fr, LatentVariables.class);
		fr.close();
		phiLink = vars.phi;
		thetaLink = vars.theta;
		psiLink = vars.psi;
		deltaLink = vars.delta;
		
		// schreibe latente Variablen in Zielverzeichnis für spätere Analysen
		FileWriter fw = new FileWriter(dName+"3latent.json");
		gson.toJson(vars, fw);
		fw.close();
		
		// schreibe latente Vokabular in Zielverzeichnis für spätere Analysen
		fw = new FileWriter(dName+"1vocabulary.json");
		gson.toJson(vocabulary, fw);
		fw.close();
		
		// schreibe latente User in Zielverzeichnis für spätere Analysen
		fw = new FileWriter(dName+"2users.json");
		gson.toJson(users, fw);
		fw.close();
		
		// erstelle 
		sortDelta(userNames, false); // Ausgabe Delta -> User zuordnung zu Communities
        sortPhi(vocabulary, divF); // Ausgabe Phi  -> Topic bezogene Wörter, flag = true f�r division und false für normal gewichtet.
        sortPsi(userNames, false);
    	sortTheta();
		
		ReportOut.reportDelta(dName+fileID, deltaUsersCom, users);	  
		ReportOut.reportPhi(dName+fileID, phiTopicWords);
		ReportOut.reportPsi(dName+fileID, psiComUsers);
		ReportOut.reportTheta(dName+fileID, thetaComTopic);
		ReportOut.exportNodesEdges(dName+fileID, deltaUsersCom, users);
    	ReportOut.exportNodes(dName+fileID, deltaUsersCom, users);
    	ReportOut.exportEdges(dName+fileID, deltaUsersCom, users);
       	
        System.out.println("");
		System.out.println("");
	}
	
		
	/**
	 * sortDelta
	 *  1. Erstellt in Array deltaUsersCom sortiert eine Liste den Usern zugeordneten Communities absteigend sortiert nach der Wahrscheinlichkeit.
	 *  2. Gibt die erste 50 Ergebnisse auf der Konsole und in dem BaseReport aus.
	 * @param itemName 		Usernames
	 * @param divF Flag 		ob speziel gewichtet werden soll
	 * @throws IOException
	 */
	public static void  sortDelta(ArrayList<String> itemName, boolean divF) throws IOException{
		deltaUsersCom = (ArrayList<Delta>[])  new  ArrayList[deltaLink.length];
		double[] divXXX = new double[deltaLink.length];
		divXXX = calculateDiv(deltaLink, divXXX);
		
		int uinc[] = new int[deltaLink[0].length+1];
		int uc[] = new int [deltaLink.length];
		double uw[] = new double [deltaLink.length];
		for(int u=0;u<deltaLink.length;u++){
			deltaListLink = new ArrayList<Delta>();
			for(int c=0;c<deltaLink[0].length;c++){
				if (divF == false) {
					deltaListLink.add(new Delta(u, c, itemName.get(u) , deltaLink[u][c]));
				} else {
					deltaListLink.add(new Delta(u, c,  itemName.get(u) , deltaLink[u][c]/divXXX[c]));
				}
			}	
			Collections.sort(deltaListLink, Collections.reverseOrder());
			deltaUsersCom[u] = new ArrayList<Delta>(deltaListLink); 
			uinc[deltaListLink.get(0).community]++;
			uc[u] = deltaListLink.get(0).community;	
			uw[u] = deltaListLink.get(0).prob;	

			if (u < 50) {
				System.out.print(deltaListLink.get(0).user+" -< "+deltaListLink.get(0).userString+"\"" + deltaListLink.get(0).community+"\"" + deltaListLink.get(0).prob);
				bW4.write(deltaListLink.get(0).user+" -< "+deltaListLink.get(0).userString+"\"" + deltaListLink.get(0).community+"\"" + deltaListLink.get(0).prob);
				for(int c=1;c<deltaLink[0].length;c++) {
						System.out.print(" -< "+deltaListLink.get(c).community+"\"" + deltaListLink.get(c).prob);
						bW4.write(" -< "+deltaListLink.get(c).community+"\"" + deltaListLink.get(c).prob);
					}
				System.out.println();
				bW4.write("\r\n");
			}
		}
		System.out.println();
		bW4.write("\r\n");
}

	/**
	 *  sortPsi		
	 *  1. Erstellt in Array psiComUsers sortiert eine Liste den Communities zugeordneten Usern absteigend sortiert nach der Wahrscheinlichkeit.
	 *  2. Gibt die erste 10 top-User zu den Communities auf der Konsole und  in dem BaseReport aus.
	 * @param itemName 		Usernames
	 * @param divF 				Flag ob speziel gewichtet werden soll
	 * @throws IOException
	 */
	public static void  sortPsi(ArrayList<String> itemName, boolean divF) throws IOException{
		psiComUsers = (ArrayList<Psi>[])  new  ArrayList[psiLink.length];
		double[] divXXX = new double[psiLink[0].length];
		divXXX = calculateDiv(psiLink, divXXX);

		int uinc[] = new int[psiLink[0].length+1];
		int uc[] = new int [psiLink[0].length];
		double uw[] = new double [psiLink[0].length];
		
		System.out.print("Psi Analyse");
		bW4.write("Psi Analyse");
		System.out.print("PSI User-Community Verteilung \r\n");
		bW4.write("PSI User-Community Verteilung \r\n");
		for(int c=0;c<psiLink.length;c++){
			psiListLink = new ArrayList<Psi>();
			 for(int u=0;u<psiLink[0].length;u++){
				if (divF == false) {
					psiListLink.add(new Psi(c, u,  itemName.get(u) , psiLink[c][u]));
				} else {
					psiListLink.add(new Psi(c,  u, itemName.get(u), psiLink[c][u]/divXXX[c]));
				}
			}	
			Collections.sort(psiListLink, Collections.reverseOrder());
			psiComUsers[c] = new ArrayList<Psi>(psiListLink); 
			
			uinc[psiListLink.get(0).community]++;
			uc[c] = psiListLink.get(0).community;	
			uw[c] = psiListLink.get(0).prob;	
	
			System.out.print("Community "+c+" ");
			bW4.write("Community "+c+" ");
			for(int u=1;u<10;u++) {
				System.out.print(u+" < "+psiListLink.get(0).user+" - "+psiListLink.get(0).userString+" - " + psiListLink.get(u).prob+" > ");
				bW4.write(u+" < "+psiListLink.get(0).user+" - "+psiListLink.get(0).userString+" - " + psiListLink.get(u).prob+" > ");
        	}
			System.out.println();
			bW4.write("\r\n");
		}
		System.out.println();
		bW4.write("\r\n");
	}

		
	/**
	 * sortPhi		
	 *  1. Erstellt in Array phiTopicWords sortiert eine Liste den Topics zugeordneten Wörtern absteigend sortiert nach der Wahrscheinlichkeit.
	 *  2. Gibt die erste 50 top-Wörter zu den Topics auf der Konsole und  in dem BaseReport aus.
	 * @param itemName
	 * @param divF
	 * @throws IOException
	 */
	public static void  sortPhi(ArrayList<String> itemName, boolean divF) throws IOException{
		phiWordTopicString = new String[phiLink.length][51];
		phiWordTopicProb = new double[phiLink.length][51];
		phiTopicWords = (ArrayList<Phi>[])  new  ArrayList[phiLink.length];
		
		double[] divXXX = new double[phiLink[0].length];
		divXXX = calculateDiv(phiLink, divXXX);
		
		System.out.print("Phi-Analyse");
		bW4.write("Phi Analyse");
		for(int t=0;t<phiLink.length;t++){
			phiListLink = new ArrayList<Phi>();
			for(int w=0;w<phiLink[0].length;w++){
				if (divF == false) {
					phiListLink.add(new Phi(t, w, itemName.get(w), phiLink[t][w]));
				} else {
					phiListLink.add(new Phi(t, w, itemName.get(w), phiLink[t][w]/divXXX[w]));		
				}
			}	
			Collections.sort(phiListLink, Collections.reverseOrder());
			phiTopicWords[t] = new ArrayList<Phi>(phiListLink); 

			System.out.print("Topic "+t+" ");
			bW4.write("Topic "+t+" ");
			for(int w=0;w<50;w++ ){
				System.out.print("\""+phiListLink.get(w).wordString+"\"" + ", ");
				bW4.write("\""+phiListLink.get(w).wordString+"\"" + ", ");
				phiWordTopicString[t][w]=phiListLink.get(w).wordString;
				phiWordTopicProb[t][w]=phiListLink.get(w).prob;
			}
			System.out.println();
			bW4.write("\r\n");
		}		
		System.out.println();
		bW4.write("\r\n");
	}
	
	/**
	 *  sortTheta		
	 *  1. Erstellt in Array thetaTopicCom sortiert eine Liste den Topics zugeordneten Commuinties absteigend sortiert nach der Wahrscheinlichkeit.
	 *  2. Gibt die Communities zu den Topics auf der Konsole und  in dem BaseReport aus.
	 * @throws IOException
	 */
	public static void  sortTheta() throws IOException{
		thetaComTopic = (ArrayList<Theta>[])  new  ArrayList[thetaLink.length];
		thetaTopicCom = new  ArrayList[thetaLink[0].length];	
			
		System.out.println("");
		System.out.println("Phi-Analyse");
		System.out.println("Communities ranked:");
		System.out.print("Rank:\t");
		bW4.write("\r\n");
		bW4.write("Phi Analyse");
		bW4.write("Communities ranked:");
		bW4.write("Rank:\t");
		for (int c=1;c<=thetaLink[0].length;c++){
				System.out.print("\t"+c);
		}
		System.out.println("");

		for (int t=0;t<thetaLink[0].length;t++ ){
			thetaListLink = new ArrayList<Theta>();
			for(int c=0;c<thetaLink.length;c++){
				thetaListLink.add(new Theta(c, t, thetaLink[c][t]));	
			}	
			Collections.sort(thetaListLink, Collections.reverseOrder());
			thetaTopicCom[t] = new ArrayList<Theta>(thetaListLink); 
			
			System.out.print("Topic: "+t);
			bW4.write("Topic: "+t);
			for(int c=0;c<thetaLink.length;c++ ){
				System.out.print("\t"+thetaListLink.get(c).community);
				bW4.write("\t"+thetaListLink.get(c).community);
				}
			System.out.println("");
			bW4.write("\r\n");
		}
		System.out.println("");
		bW4.write("\r\n");
		
		System.out.println("Topic ranked:");
		System.out.print("Rank\t");
		bW4.write("Topic ranked:");
		bW4.write("Rank\t");
		for (int t=0;t<thetaLink.length;t++) {
			System.out.print("\t"+t);
			bW4.write("\t"+t);
		}
		System.out.println("");
		bW4.write("\r\n");
		
		for(int c=0;c<thetaLink.length;c++){
			thetaListLink = new ArrayList<Theta>();
			for(int t=0;t<thetaLink[0].length;t++ ){
				thetaListLink.add(new Theta(c, t, thetaLink[c][t]));	
			}	
			Collections.sort(thetaListLink, Collections.reverseOrder());
			thetaComTopic[c] = new ArrayList<Theta>(thetaListLink); 
			
			System.out.print("Community: "+c);
			bW4.write("Community: "+c);
			for(int t=0;t<thetaLink[0].length;t++ ){
				System.out.print("\t"+thetaListLink.get(t).topic);
				bW4.write("\t"+thetaListLink.get(t).topic);
			}
			System.out.println();
			bW4.write("\r\n");
		}
		System.out.println();
		bW4.write("\r\n");
	}
	
	/**
	 *  calculateDiv	Erstellt in Array mit summierten Wahrscheinlichkeiten zwecks alternativer Gewichtung 
	*/
	public static double[]  calculateDiv(double[][] xxxLink, double[] divXXX) {
		divXXX = new double[xxxLink[0].length];
		for(int w=0;w<xxxLink[0].length;w++){
			for(int t=0;t<xxxLink.length;t++){
				divXXX[w]+= xxxLink[t][w];
			}
		}
		return divXXX;
	}
	
	/**
	 *  getFileN		Liest erste Zeile aus den Part-Files zur Übergabe der gewählten Parameter 
	 * @param fromF		Dateiname
	 * @return erste Zeile als Rückgabe
	 * @throws IOException
	*/
	public static String getFileN(String fromF) throws IOException {
		BufferedReader bfF = new BufferedReader(new FileReader(fromF));
		try {
			String f = bfF.readLine();
			bfF.close();
			if (f.split(" ").length >=1) dataName=f.split(" ")[0];
			if (f.split(" ").length >=2) pName=f.split(" ")[1];
			if (f.split(" ").length >=3)  p2=f.split(" ")[2];
			return f;
		}
		catch (IOException E) {
			return "";
		}
	}	
}	 


