package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.rapidminer.kobra.topicmodels.SamplersLDA;

import gnu.trove.list.array.TIntArrayList;
/**
 * Wird ausgef�hrt nach: Part1RawToReduced
 * Hier werden Freundschaften und Dokumente für die Eingabe in Link-Content bestimmt. Die ursprüngliche Struktur wird in eine Userliste und eine Dokumentenliste umgewandelt.
 * @author Andreas Sitta
 * @version 1.0
 *
 */

public class Part2ReducedToInput {
	static	Gson gson = new Gson();
	static	Type listType1 = new TypeToken<ArrayList<User>>(){}.getType();
	static	BufferedWriter bW2;
	static 	String p2, dataName = "", dName = "", pName = "";
	static 	boolean directedLink = true; //gibt an ob Freundschaften gerichtet oder ungerichtet sein sollen
	static   int minimumFriendPosts =2; //gibt an, wie oft geantwortet werden muss um als Freund zu gelten
	
	/**
	 * 
	 * @param args nicht verwendet.
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {
		// Protokoll von Part 1 in Protokoll Part2 kopieren
		getFileN("output/Part1.txt");
		dName = "output/"+dataName+"/";
		if (directedLink) pName+= "-mFP"+minimumFriendPosts+"dir";
		else pName+= "-mFP"+minimumFriendPosts+"undir";

		MyTools.copyFile("output/Part1.txt","output/Part2.txt",dataName+" "+pName);
		
		bW2 = new BufferedWriter(new FileWriter("output/Part2.txt",true));
		bW2.write("\r\n\r\n**********************************   Part 2   ****************************************\r\n\r\n");
        
        //Daten einlesen
		System.out.println("Daten einlesen");
		
		Reader r1 = new FileReader("1reduced.json");
		NewData myData = gson.fromJson(r1, NewData.class);
		ArrayList<User> users= gson.fromJson(new FileReader("1users.json"), listType1) ;
	
		int numUsers = users.size();
		
		//answerCounts gibt an wie oft einem Threadersteller von welchem User geantwortet wurde
		ArrayList<TIntArrayList> answerCounts = new ArrayList<TIntArrayList>(numUsers);
		for(int i=0;i<numUsers;i++){
			answerCounts.add(new TIntArrayList());
		}
		
		System.out.println("Posts nach Threads sortieren");
		Collections.sort(myData.cleanedPosts);//Posts nach Threads sortieren
		System.out.println("Threads ohne Erstellerpost l�schen");
		removeBrokenThreads(myData.cleanedPosts);//Threads ohne Erstellerpost löschen
		

		//Posts eines Threads zusammenfassen: Falls ausgehend vom 0. Post der Nächste zum Thread gehört: Mergen und hinteren löschen, falls neuer Thread kommt: den vorherigen Thread/zusammengefasstenPost speichern und löschen
		int docID=0;
		int thread = myData.cleanedPosts.get(0).thread;
		int creator = myData.cleanedPosts.get(0).author;
		while (myData.cleanedPosts.size()>0) {
			if(myData.cleanedPosts.size()%1000==0)
				System.out.println("Dokumente erstellen, ToDo: " + myData.cleanedPosts.size());
			// Noch ein Post im gleichen Thread?
			if (myData.cleanedPosts.size()>1 && thread == myData.cleanedPosts.get(1).thread) {
				if (creator != myData.cleanedPosts.get(1).author)
					answerCounts.get(creator).add(myData.cleanedPosts.get(1).author); //F�r die Freundschaftsliste speichern wer dem Threadersteller geantwortet hat
				myData.cleanedPosts.get(0).words.addAll(myData.cleanedPosts.get(1).words);// Posts zusammenfassen
				myData.cleanedPosts.remove(1);//hinteren Post (in 0. eingegliedert) l�schen
				
				//Doppelte Wörter (durch Mergeprozess entstanden) zusammenfassen (Worthäufigkeit addieren)
				Collections.sort(myData.cleanedPosts.get(0).words);
				mergeWords(myData.cleanedPosts.get(0));
			}
			
			//Thread fertig gemergt (nächster Post gehört zum nächsten Thread). Abspeichern
			else{
				Document doc = new Document(docID, myData.cleanedPosts.get(0).words, myData.cleanedPosts.get(0).published);
				users.get(myData.cleanedPosts.get(0).author).docs.add(doc);// Dokument zum User hinzuf�gen
				myData.cleanedPosts.remove(0);
				if(myData.cleanedPosts.size()>0){
					thread = myData.cleanedPosts.get(0).thread;
					creator = myData.cleanedPosts.get(0).author;
					docID++;
				}
			}
		}
		
		//Freundschaftsliste anhand der Antworten auf Threadersteller erstellen
		createFriendList(numUsers, answerCounts, users, minimumFriendPosts, directedLink); 
		
		// Freundeslisten sortieren 
		for (int i = 0; i < numUsers; i++) {
			if(i%100==0)
				System.out.println("Freunde sortieren: " + (numUsers-i));	
			Collections.sort(users.get(i).friends);
		}

		//User l�schen, die weder Dokumente, noch Freunde haben
		ArrayList<Integer> convertList = new ArrayList<Integer>(); //convertierungsliste, wird in delUserWithoutDocOrFriend angelegt
		System.out.println("User ohne Document und Freund l�schen");	
		delUserWithoutDocOrFriend(users, convertList);
		updateIDs(users, convertList);
		
		//Abspeichern
		System.out.println("Speichern...");	
		FileWriter fw = new FileWriter("2users.json");
		gson.toJson(users, fw);
		fw.close();
		System.out.println("makeTrainTestData");	
		makeTrainTestData(users);
		SamplersLDA.convertData();
        bW2.close();
		System.out.println("ENDE!!!");	
	}
	
	
/**
 * 	merge in sortierter W�rterliste doppelte W�rter (H�ufigkeiten addieren)
 * @param post
 * @throws IOException
 */
	public static void mergeWords(CleanedPost post) throws IOException {
		int i =0;
		while(i+1 < post.words.size()){
			while((i+1 <post.words.size())&&(post.words.get(i).id==post.words.get(i+1).id)){
				post.words.get(i).freq += post.words.get(i+1).freq;
				post.words.remove(i+1);
			}
			i++;
		}
	}
	
	/**
	 * Freundschaftsliste anhand der Antworten auf Threadersteller erstellen
	 * @param numUsers
	 * @param answerCounts
	 * @param users
	 * @param neededAnswersForFriendship
	 * @param directed
	 * @throws IOException
	 */
	public static void createFriendList(int numUsers, ArrayList<TIntArrayList> answerCounts, ArrayList<User> users, int neededAnswersForFriendship, boolean directed) throws IOException { 
		//neededAnswersForFriendship: Zahl wie oft geantwortet werden muss um als freund zu z�hlen.
		int counter;
		for (int i = 0; i < numUsers; i++) { // Freundschaftsliste erstellen (anders rum):Freundschaft: von jemandem x Antworten erhalten
			if(i%100==0)
				System.out.println("Freundschaftsliste erstellen Todo:" + (numUsers-i));	
			answerCounts.get(i).sort();
			counter = 0;
			if(answerCounts.get(i).size()>0){
				int id = answerCounts.get(i).get(0);
				for (int j = 0; j < answerCounts.get(i).size(); j++) {
					if (id == answerCounts.get(i).get(j))
						counter++;
					else{
						if (counter >= neededAnswersForFriendship){
							users.get(id).friends.add(i);
							if (directed == false) users.get(i).friends.add(id); 
						}
						counter=1;
						id = answerCounts.get(i).get(j);
					}
				}
				if (counter >= neededAnswersForFriendship){// letzten beachten
					users.get(answerCounts.get(i).get(answerCounts.get(i).size()-1)).friends.add(i);
					users.get(i).friends.add(answerCounts.get(i).get(answerCounts.get(i).size()-1));
				}
			}
		}
	}
	
	/**
	 * User l�schen, die weder Dokumente, noch Freunde haben
	 * @param users
	 * @param convertList erforderlich um die IDs anschlie�end zu aktualisieren
	 * @throws IOException
	 */
	public static void delUserWithoutDocOrFriend(ArrayList<User> users,  ArrayList<Integer> convertList) throws IOException {
		int deleted=0;
		int iter=0;
		for(int i=0;i<users.size();i++){
			if(users.get(i).docs.size()==0 && users.get(i).friends.size()==0){ 
				deleted++;
				users.remove(i);
				i--;
				convertList.add(null);
			}
			else
				convertList.add(iter-deleted);
			iter++;
		}
		System.out.println("delUserWithoutDocOrFriend:" +iter+" "+deleted+" "+users.size()+" "+convertList.size());	
		bW2.write("User l�schen: " +iter+" "+deleted+" "+users.size()+" "+convertList.size()+"\r\n");	
	}
	
	/**
	 * �berall IDs aktualisieren. Wird ben�tigt, falls in  {@link #delUserWithoutDocOrFriend} User gel�scht werden.
	 * @param users
	 * @param convertList
	 */
	public static void updateIDs(ArrayList<User> users, ArrayList<Integer> convertList){
		for(int i=0;i<users.size();i++){
			users.get(i).id = i;
			for(int j=0; j<users.get(i).friends.size();j++){
				if(convertList.get(users.get(i).friends.get(j))==null){
					users.get(i).friends.remove(j);
					j--;
					System.out.println("Friend:null");
				}
				else
					users.get(i).friends.set(j, convertList.get(users.get(i).friends.get(j)));			
			}
		}
	}
	
	
	/**
	 * L�scht Threads die keinen Erstellerpost haben
	 * @param posts
	 */
	public static void removeBrokenThreads (ArrayList<CleanedPost> posts){
		int thread;
		int i=0;
		while(i<posts.size()){
			thread=posts.get(i).thread;
			if(posts.get(i).parent!=0) //Gibt kein Erstellerpost
				while((i<posts.size()) && posts.get(i).thread==thread)
					posts.remove(i);
			else //Gibt Erstellerpost
				while((i<posts.size()) && posts.get(i).thread==thread)
					i++;
		}
	}

	
	/**
	 * Erstellt Trainings- und Testdatensatz. Ersten (zeitlich gesehen) 75% der Daten werden zum Training genommen. Der Rest ist dann Testdatensatz. Diese werden abgespeichert.
	 * @param trainData
	 * @throws IOException
	 */
	public static void makeTrainTestData(ArrayList<User> trainData) throws IOException{
		//Trainingssatz erstellen
		ArrayList<User> testData = new ArrayList<User>();
		System.out.println("makeTrainData");
		Date splitDate;
		ArrayList<Date> datumsliste = new ArrayList<>();
		for(int i=0;i<trainData.size();i++){
			User curUser=trainData.get(i);
			testData.add(new User(curUser.id, curUser.name, curUser.friends)); //f�r Testdatensatz neue liste erstellen
			for(int j=0;j<curUser.docs.size();j++){
				datumsliste.add(curUser.docs.get(j).published);
			}
		}
		Collections.sort(datumsliste);
		splitDate = datumsliste.get((int) (datumsliste.size()*0.75));
		
		//Letzten 25% der Dokumente l�schen; Dokument von Trainingssatz in den neuen Testsatz verschieben
		for(int i=0;i<trainData.size();i++){
			User curUser=trainData.get(i);
			for(int j=0;j<curUser.docs.size();j++){
				if(curUser.docs.get(j).published.compareTo(splitDate) > 0){
					testData.get(i).docs.add(curUser.docs.get(j));
					curUser.docs.remove(j);
					j--;
				}
			}
		}
		Gson gson = new Gson();
		FileWriter fw = new FileWriter("2train.json");
		gson.toJson(trainData, fw);
		fw.close();
		fw = new FileWriter("2test.json");
		gson.toJson(testData, fw);
		fw.close();
	}
	
	/**
	 * Erstellt Pfad
	 * @param fName Pfadname
	 * @throws IOException
	 */
	public static void makeOutputDirectories(String fName) throws IOException{
		File f = new File("output"); //Verzeichnis erstellen wenn noch nicht da
		if (! f.exists()) f.mkdir();
		f = new File("output/"+fName); 
		if (! f.exists()) f.mkdir();
		dName = "output/"+fName+"/";
		pName+= "-mFP"+minimumFriendPosts+"dirL"+directedLink;
	}		
	
	public static String getFileN(String fromF) throws IOException {
		BufferedReader bfF = new BufferedReader(new FileReader(fromF));
		try {
			String f = bfF.readLine();
			bfF.close();
			if (f.split(" ").length >=1) dataName=f.split(" ")[0];
			if (f.split(" ").length >=2) pName=f.split(" ")[1];
			if (f.split(" ").length >=3)  p2=f.split(" ")[2];
			return f;
		}
		catch (IOException E) {
			return "";
		}
	}	
}
