package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gnu.trove.list.array.TIntArrayList;
/** 
 * Hier werden unnötige Infos, seltene Wörter, Wörter einer Blacklist, gelöscht. Die Struktur bleibt erhalten. Es folgt dann die richtige Vorverabeitung in Klasse Part2ReducedToInput
 * @author Andreas Sitta
 * @version 1.0
 * 
*/

public class Part1RawToReduced {
	static Type listType = new TypeToken<ArrayList<String>>() {}.getType();
	static Gson gson = new Gson();
	static String[] stopWords;
	static ArrayList<String> vocabulary = new ArrayList<String>();   //Zum Rückcodieren von int nach String
	static ArrayList<User> users = new ArrayList<User>();
	static NewData newData = new NewData();   //Daten werden in Objekt NewData gespeichert (Vor-Vorverarbeitung)
	static BufferedWriter bW1, bWL1,bWL2 ;
	static String fName = "", dName = "", pName = "";
	int[] tfi;
	static int[] ni;
	static double[] tfidf;
	
	//******** Parameter zum Testen
	static int upperBound = 30;
	static int percentToKeep = 10;
	static String dataName = "TestData"; // Input Datei mit aussagekräftigem Namen, wird aus data/ geladen. Dateiname wird über die Partx.txt für die speicherung der Auswertungen in Part4 übergeben
	
	
	/**
	 * 
	 * @param args nicht verwendet.
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {
		//Zum erstellen einer Ordnerstruktur mit Parameterbezeichnug
		makeOutputDirectories(dataName);
		dName = "output/"+dataName+"/";
		pName+= "-up"+upperBound+"kp"+percentToKeep;
		bW1 = new BufferedWriter(new FileWriter("Output/Part1.txt"));
		bW1.write(dataName+" "+ pName+"\r\n");
		
		//Einlesen der Daten
		System.out.println("Daten einlesen");
		Data Data1 = gson.fromJson(new FileReader("data/"+dataName+".json"), Data.class);

		bW1.write("**********************************   Part 1   ****************************************\r\n\r\n");
		bW1.write("Input file = "+dataName+"\r\n");	
		bW1.write("Data1.size: "+Data1.size()+"\r\n"); 

		//Stopwordlisten laden und erstellen
		ArrayList<String> stopIn = gson.fromJson(new FileReader("en.json"), listType);
		bW1.write("Stop list = en.json "+stopIn.size()); bW1.newLine();
		stopIn.addAll(gson.fromJson(new FileReader("de.json"), listType));
		bW1.write("Stop list = de.json "+stopIn.size()); bW1.newLine();
		Collections.sort(stopIn);
		stopWords = stopIn.toArray(new String[0]);
		stopIn = null;
		
		//Vokabular und Userliste erstellen
		for (int i = 0; i < Data1.size(); i++) {
			if (i % 1000 == 0)
				System.out.println("1. Durchlauf: " + i + " von " + Data1.size());

			//ThreadIDKürzen (nur noch die ID, nicht mehr den Titel),  
			Data1.getPost(i).thread = getThreadID(Data1.getPost(i).thread);
			//Alle Sonderzeichen löschen
			Data1.getPost(i).text = Data1.getPost(i).text.replaceAll("\u00df", "ss"); // ersetzt ß durch ss
			Data1.getPost(i).text = Data1.getPost(i).text.replaceAll("\u0308", "e"); // ersetzt ä... durch ae...
			Data1.getPost(i).text = Data1.getPost(i).text.replaceAll("\u0304-\0310", ""); // wirft andere diakritische Zeichen (´ ` ~ ...) raus siehe Allah
			Data1.getPost(i).text = Data1.getPost(i).text.replaceAll("[^A-Za-zÄäÖöÜüß]", " "); // ersetzt alle anderen Zeichen durch *blank

			//Wörter des aktuellen Post zum Vokabular hinzufügen (nur Wörter größer als Länge 2 und nicht in Blacklist)
			vocabulary.addAll(getWordsBigger(Data1.getPost(i).text, 2, true));
			
			//Userliste anlegen
			int search = Collections.binarySearch(users, Data1.getPost(i).author, new NameComparator());
			if (search < 0) {//Falls user noch nicht in liste:
				users.add(-search - 1, new User(Data1.getPost(i).author)); //User hinzufügen
			}
		}
		bW1.write("1. Lauf: User eingelesen = "+users.size()); bW1.newLine();

		ReportOut.writeWordFreqList(dName+ "VocabInit-"+pName, vocabulary);
		
		bW1.write("1-1. Lauf: Wortumfang = "+vocabulary.size()); bW1.newLine();
		for (int u = 0; u < users.size(); u++) //Aufsteigende Ids verteilen
			users.get(u).id = u;

		//Wörterliste bearbeiten
		System.out.println("Sortieren");
		//Wörterliste Sortieren (doppelte vorhanden)
		Collections.sort(vocabulary); 
		System.out.println("bounds");
		bW1.write("1. Lauf: Zipf % to keep = "+percentToKeep+" upper # to cut: "+upperBound); bW1.newLine();

		int[] bounds = getPercentageLimit(vocabulary, percentToKeep, upperBound); //Häufigkeitsgrenzen, dass nur häufigsten z.B. 20% behalten werden und z.B. 20 Häufigsten Wörter gelöscht werden
		bW1.write("1. Lauf: Zipf = "+bounds[0]+" "+bounds[1]); bW1.newLine();
	
		System.out.println("delRareWords");
		vocabulary = delRareFrequentWords(vocabulary, bounds[0], bounds[1]); //nur häufigsten 20% behalten 
		bW1.write("1-2. Lauf: Vocabulatory = "+vocabulary.size()); bW1.newLine();

		//Jeden Post reduzieren(Wörter die nicht im Vokabular und Blacklist löschen) und dann den cleanedPost speichern
		ArrayList<String> editedText = null;
		for (int i = 0; i < Data1.size(); i++) {
			if (i % 1000 == 0)
				System.out.println("2. Durchlauf: " + i + " von " + Data1.size());
			editedText = getWordsBigger(Data1.getPost(i).text, 2, true);
			Collections.sort(editedText);
			for (int j = 0; j < editedText.size(); j++) {
				if (Collections.binarySearch(vocabulary, editedText.get(j)) < 0) {
					editedText.remove(j);
					j--;
				}
			}

			if (editedText.size() <= 5) { //Falls ein Post jetzt fast leer ist: löschen
				Data1.removePost(i);
				i--;

			} else {				
				//Wörter werden nur noch mit WortID und Häufigkeit abgespeichert
				ArrayList<Word> words = wordListToIDFreqList(editedText, vocabulary);
				//Post ein Erstellungspost?			
				if (Data1.getPost(i).parent == null || Data1.getPost(i).parent.equals(""))
					newData.cleanedPosts.add(new CleanedPost(Data1.getPost(i).id, 0, Integer.parseInt(Data1.getPost(i).thread.replaceAll("[^0-9]","")), Collections.binarySearch(users, Data1.getPost(i).author, new NameComparator()), words, Data1.getPost(i).published));
				else
					newData.cleanedPosts.add(new CleanedPost(Data1.getPost(i).id, Integer.parseInt(Data1.getPost(i).parent.replaceAll("[^0-9]","")), Integer.parseInt(Data1.getPost(i).thread.replaceAll("[^0-9]","")), Collections.binarySearch(users, Data1.getPost(i).author, new NameComparator()), words, Data1.getPost(i).published));
				}
		}
		
		bW1.write("2. Lauf - Data1.size: "+Data1.size()); bW1.newLine();
		bW1.write("2. Lauf - Vocabulatory: "+vocabulary.size()); bW1.newLine();
		
		//Speichern
		System.out.println("Speichern: 1reduced");
		FileWriter fw = new FileWriter("1reduced.json");
		gson.toJson(newData, fw);
		fw.close();
		System.out.println("Speichern: 1vocabulary");
		fw = new FileWriter("1vocabulary.json");
		gson.toJson(vocabulary, fw);
		fw.close();
		System.out.println("Speichern: 1users");
		fw = new FileWriter("1users.json");
		gson.toJson(users, fw);
		fw.close();
        bW1.close();
		System.out.println("ENDE!!!");
	}

	/**
	 * Geht alle Zeichen eines Textes durch und gibt die W�rter aus.
	 * @param Text text in Kleinbuchstaben
	 * @param bigger Grenze, sodass nur W�rter, die l�nger als "bigger" sind ausgegeben werden
	 * @param delStopWords falls Stopwords gel�scht werden sollen
	 * @return Gibt eine Liste mit W�rtern wieder
	 */
	//Über Text iterieren und Wörter rausfinden (Wörter teilweise doppelt), die länger als "bigger" sind
	public static ArrayList<String> getWordsBigger(String Text, int bigger, boolean delStopWords) {
		ArrayList<String> allWords = new ArrayList<String>();
		String wordToken = new String("");
		int c = 0;
		while (c < Text.length()) {
			if (Character.isLetter(Text.charAt(c))) { //Umlaute?
				wordToken += Text.charAt(c);
			} else {
				if (!wordToken.equals("")) {
					if (wordToken.length() > bigger) {
						if (delStopWords) {
							if (Arrays.binarySearch(stopWords, wordToken) < 0)
								allWords.add(wordToken);
						} else
							allWords.add(wordToken);
					}
					wordToken = "";
				}
			}
			c++;
		}
		//Für das letzte Wort
		if (delStopWords) {
			if (wordToken.length() > bigger && Arrays.binarySearch(stopWords, wordToken) < 0)
				allWords.add(wordToken);
		} else {
			if (wordToken.length() > bigger)
				allWords.add(wordToken);
		}
		return allWords;
	}
	
/**
 * Typecast von ArrayList zu TIntArrayList
 * @param input
 * @return
 */
	public static TIntArrayList strListToIntList(ArrayList<String> input) {
		TIntArrayList output = new TIntArrayList();
		for (int i = 0; i < input.size(); i++) {
			output.add(Integer.parseInt(input.get(i)));
		}
		return output;
	}

	/**
	 * Convertiert einen Stringtext zu einer Liste von Wortobjekten mit ID und H�ufigkeit
	 * @param words W�rter eines Textes
	 * @param vocabulary Vokabular
	 * @return Liste mit Wortobjekten
	 */
	//Gibt eine Liste zurück wie häufig jedes Wort vorkommt
	public static ArrayList<Word> wordListToIDFreqList(ArrayList<String> words, ArrayList<String> vocabulary) {
		ArrayList<Word> idFreqLists = new ArrayList<Word>();
		String currentWord = words.get(0);
		int wordCount = 1;
		for (int i = 1; i < words.size(); i++) {
			if (currentWord.equals(words.get(i)))
				wordCount++;
			else {
				idFreqLists.add(new Word(Collections.binarySearch(vocabulary, currentWord), wordCount));
				wordCount = 1;
				currentWord = words.get(i);
			}
		}
		idFreqLists.add(new Word(Collections.binarySearch(vocabulary, currentWord), (wordCount)));//Letztes Wort prüfen
		return idFreqLists;
	}

/**
 * Gibt die IDs einer Wortliste wieder (Position im Vokabular)
 * @param toConvert
 * @param convertList
 * @return
 */
	public static TIntArrayList stringToID(ArrayList<String> toConvert, ArrayList<String> convertList) {
		TIntArrayList output = new TIntArrayList();
		for (int i = 0; i < toConvert.size(); i++) {
			output.add(Collections.binarySearch(convertList, toConvert.get(i)));
		}
		return output;
	}

	/**
	 * Gibt die ID eines Users wieder (Position in Userliste)
	 * @param toConvert
	 * @param convertList
	 * @return
	 */
		public static int stringToID(String toConvert, ArrayList<String> convertList) {
		return Collections.binarySearch(convertList, toConvert);
	}

	/**
	 * //Wörter die seltener als "min" und häufiger als "max" auftreten entfernen
	 * @param Words
	 * @param min
	 * @param max
	 * @return
	 */
	public static ArrayList<String> delRareFrequentWords(ArrayList<String> Words, int min, int max) {
		ArrayList<String> commonWords = new ArrayList<String>();
		String current = Words.get(0);
		int wordCount = 1;
		for (int j = 1; j < Words.size(); j++) {
			if (current.equals(Words.get(j)))
				wordCount++;
			else {
				if (wordCount >= min && wordCount <= max) {
					commonWords.add(Words.get(j - 1)); // String hinten entfernen rückgänging
				}
				wordCount = 1;
				current = Words.get(j);
			}
		}
		if (wordCount >= min && wordCount <= max)
			commonWords.add(Words.get(Words.size() - 1));//Letztes Wort prüfen

		return commonWords;
	}

	/**
	 * Worthäufigkeitsgrenze zurückgeben, bei der nur die 20% häufigsten Wörter vorkommen (Wörter die 1 mal vorkommen vorher gelöscht)
	 * @param Words
	 * @param percentToKeep
	 * @param upperBound
	 * @return
	 */
	public static int[] getPercentageLimit(ArrayList<String> Words, int percentToKeep, int upperBound) {
		//Alle Häufigkeiten in Liste aufsteigend sortieren;
		ArrayList<Integer> freqs = new ArrayList<Integer>();
		String current = Words.get(0);
		int wordCount = 1;
		for (int j = 1; j < Words.size(); j++) {
			if (current.equals(Words.get(j)))
				wordCount++;
			else {
				if (wordCount > 3) //Alle Wörter die nur 3 mal vorkommen werden gelöscht, dann 20% genommen
					freqs.add(wordCount);
				wordCount = 1;
				current = Words.get(j);
			}
		}
		if (wordCount > 3)
			freqs.add(wordCount); //letzten berücksichtigen
		Collections.sort(freqs); //Häufigkeiten sortieren
		int[] out = { freqs.get((freqs.size() / 100) * (100 - percentToKeep)), freqs.get(freqs.size() - upperBound) }; //auch die "upperBound" häufigsten Wörter löschen
		return out;
	}

	/**
	 * 	Wörter einer Blacklist löschen
	 * @param Words
	 * @param blacklist
	 * @return
	 */
	public static ArrayList<String> delBlacklist(ArrayList<String> Words, String[] blacklist) {
		for (int i = 0; i < stopWords.length; i++) {
			int search = Collections.binarySearch(Words, blacklist[i]);
			while (search > 0) {
				Words.remove(search);
				search = Collections.binarySearch(Words, blacklist[i]);
			}
		}
		return Words;
	}

	/**
	 * Gibt eine nach der H�ufigkeit absteigende Liste von W�rtern zur�ck
	 * @param words
	 * @return
	 */
	public static ArrayList<StringWord> getWordFreqs(ArrayList<String> words) {
		ArrayList<StringWord> FreqLists = new ArrayList<StringWord>();
		String currentWord = words.get(0);
		int wordCount = 1;
		for (int i = 1; i < words.size(); i++) {
			if (currentWord.equals(words.get(i)))
				wordCount++;
			else {
				FreqLists.add(new StringWord(currentWord, wordCount));
				wordCount = 1;
				currentWord = words.get(i);
			}
		}

		FreqLists.add(new StringWord(currentWord, wordCount));//letztes Wort

		Collections.sort(FreqLists, new StringFreqComparator());
		Collections.reverse(FreqLists);
		return FreqLists;
	}

	/**
	 * ThreadIDKürzen, sodass nur noch die ID vorkommt
	 * @param threadName Vorausgesetzter Aufbau: ID gefolgt von "-" gefolgt von String
	 * @return int ID als String
	 */
	public static String getThreadID(String threadName) {
		int c = 0;
		String newThreadID = "";
		while ((c < threadName.length()) && (threadName.charAt(c) != '-')) {
			newThreadID = newThreadID + threadName.charAt(c);
			c++;
		}
		return newThreadID;
	}
	

	public static void makeOutputDirectories(String dataName) throws IOException{
		File f = new File("output"); //Verzeichnis erstellen wenn noch nicht da
		if (! f.exists()) f.mkdir();
		f = new File("output/"+dataName); 
		if (! f.exists()) f.mkdir();
		dName = "output/"+dataName+"/";
	}		
}