package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Comparator;

/**
 * Hilfsklasse zum Vergleichen der Namen zweier User.
 * @author Andreas Sitta
 * @version 1.0
 *
 */public class NameComparator  implements Comparator<Object> {

	    @Override
	    public int compare(Object o1, Object o2) {
	        String o1Id = getName(o1);
	        String o2Id = getName(o2);
	        return o1Id.compareTo(o2Id);
	    }

	    private String getName(Object o) {
	        if (o instanceof String) {
	            return (String) o;
	        }
	        else if (o instanceof User) {
	            return ((User) o).name;
	        }
	        else {
	            throw new IllegalArgumentException("Can only get ID from A or B");
	        }
	    }
}
	

