package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.ArrayList;
import java.util.Date;

/** 
 * CleanedPost Objekt stellt einen reduzierten Post dar. Wörter werden als Wortobjekte abgespeichert, Autor und Threadname als ID gespeichert,
 * @author Andreas Sitta
 * @version 1.0
 *
 */
public class CleanedPost implements Comparable<CleanedPost> {
	public int id;
	public int parent;
	public int thread;
	public ArrayList<Word> words;
	public int author = 0;
	public Date published;

	@Override
	public int compareTo(CleanedPost post) {
		if (Integer.compare(this.thread, post.thread) == 0)
			return Integer.compare(this.id, post.id);
		else
			return Integer.compare(this.thread, post.thread);
	}

	public CleanedPost(int id, int parent, int thread, int author, ArrayList<Word> words,  Date published) {
		this.id = id;
		this.parent = parent;
		this.thread = thread;
		this.author = author;
		this.words = words;
		this.published = published;
	}

	public CleanedPost(String id, int parent, int thread, int author, ArrayList<Word> words,  Date published) {
		this.id = Integer.parseInt(id.replaceAll("[^0-9]",""));
		this.parent = parent;
		this.thread = thread;
		this.author = author;
		this.words = words;
		this.published = published;
	}

	public CleanedPost(String id, int thread, int author, ArrayList<Word> words,  Date published) {
		this.id = Integer.parseInt(id.replaceAll("[^0-9]",""));
		this.thread = thread;
		this.author = author;
		this.words = words;
		this.published = published;
	}

}
