package com.rapidminer.operator.learner.meta;

import java.util.Iterator;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.LogService;

public class StandardWeightedPerformanceMeasures extends
		AbstractWeightedPerformanceMeasures {

	public StandardWeightedPerformanceMeasures(ExampleSet exampleSet)
			throws OperatorException {
		super(exampleSet);
	}

	@Override
	protected void initStatistics(ExampleSet exampleSet) {
		Iterator<Example> reader = exampleSet.iterator();
		double sumOfWeights = 0;

		while (reader.hasNext()) {
			// crisp base classifier, multi-class prediction problems possible
			Example exa = reader.next();
			double exaW = exa.getWeight();
			sumOfWeights += exaW;
			int eLabel = (int) (exa.getLabel());
			int ePred = (int) (exa.getPredictedLabel());

			if ((ePred >= 0 && ePred < this.predictions.length) && (eLabel >= 0 && eLabel < this.labels.length)) {
				this.unweighted_num_pred_label[ePred][eLabel]++;

				this.labels[eLabel] += exaW;
				this.predictions[ePred] += exaW;
				this.pred_label[ePred][eLabel] += exaW;
			} else { // try to ignore unrecognized labels and predictions
				exa.setWeight(0);
				exa.setLabel(0);
				exa.setPredictedLabel(0);
				LogService.getGlobal().log("WeightedPerformanceMeasures: Deleted example with illegal label or prediction (" + eLabel + ", " + ePred + ")!", LogService.WARNING);
			}
		}

		if (sumOfWeights > 0) {
			// If sum is 0 all examples have been "explained deterministically"!
			// Otherwise: Normalize!
			for (int i = 0; i < this.predictions.length; i++) {
				this.predictions[i] /= sumOfWeights;
				for (int j = 0; j < this.labels.length; j++) {
					this.pred_label[i][j] /= sumOfWeights;
				}
			}

			for (int j = 0; j < this.labels.length; j++) {
				this.labels[j] /= sumOfWeights;
			}
		}
		else { // Assign default values to all fields.
			double defaultPredProb = 1 / ((double) this.predictions.length);
			double defaultLabelProb = 1 / ((double) this.labels.length);
			double defaultPredLabelProb = defaultPredProb * defaultLabelProb;

			for (int i = 0; i < this.predictions.length; i++) {
				this.predictions[i] = defaultPredProb;
				for (int j = 0; j < this.labels.length; j++) {
					this.pred_label[i][j] = defaultPredLabelProb;
				}
			}
			for (int j = 0; j < this.labels.length; j++) {
				this.labels[j] = defaultLabelProb;
			}
		}
	}

}
