package com.rapidminer.operator.learner.meta;

import java.util.Iterator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.LogService;

public class FuzzyWeightedPerformanceMeasures extends AbstractWeightedPerformanceMeasures {

	public FuzzyWeightedPerformanceMeasures(ExampleSet exampleSet) throws OperatorException {
		super(exampleSet);
	}

	@Override
	protected void initStatistics(ExampleSet exampleSet) {
		Iterator<Example> reader = exampleSet.iterator();
		double sumOfWeights = 0;

		Attribute labelAttribute = exampleSet.getAttributes().getLabel();
		String positiveClass = labelAttribute.getMapping().getPositiveString();
		String negativeClass = labelAttribute.getMapping().getNegativeString();
		int positiveIdx = labelAttribute.getMapping().getPositiveIndex();
		int negativeIdx = labelAttribute.getMapping().getNegativeIndex();
		
		
		while (reader.hasNext()) {
			// crisp base classifier, multi-class prediction problems possible
			Example exa = reader.next();
			double exaW = exa.getWeight();
			int eLabel = (int) (exa.getLabel());
			int ePred = (int) (exa.getPredictedLabel());
			double positiveConfidence = exa.getConfidence(positiveClass);
			double negativeConfidence = exa.getConfidence(negativeClass);

			sumOfWeights += exaW;
			

			if ((ePred >= 0 && ePred < this.predictions.length) && (eLabel >= 0 && eLabel < this.labels.length)) {
				this.unweighted_num_pred_label[positiveIdx][eLabel] += positiveConfidence;
				this.unweighted_num_pred_label[negativeIdx][eLabel] += negativeConfidence;

				this.labels[eLabel] += exaW;
				this.predictions[positiveIdx] += exaW * positiveConfidence;
				this.predictions[negativeIdx] += exaW * negativeConfidence;
				this.pred_label[positiveIdx][eLabel] += exaW * positiveConfidence;
				this.pred_label[negativeIdx][eLabel] += exaW * negativeConfidence;
			} else { // try to ignore unrecognized labels and predictions
				exa.setWeight(0);
				exa.setLabel(0);
				exa.setPredictedLabel(0);
				LogService.getGlobal().log("WeightedPerformanceMeasures: Deleted example with illegal label or prediction (" + eLabel + ", " + ePred + ")!", LogService.WARNING);
			}
		}


		if (sumOfWeights > 0) {
			// If sum is 0 all examples have been "explained deterministically"!
			// Otherwise: Normalize!
			for (int i = 0; i < this.predictions.length; i++) {
				this.predictions[i] /= sumOfWeights;
				for (int j = 0; j < this.labels.length; j++) {
					this.pred_label[i][j] /= sumOfWeights;
				}
			}

			for (int j = 0; j < this.labels.length; j++) {
				this.labels[j] /= sumOfWeights;
			}
		}
		else { // Assign default values to all fields.
			double defaultPredProb = 1 / ((double) this.predictions.length);
			double defaultLabelProb = 1 / ((double) this.labels.length);
			double defaultPredLabelProb = defaultPredProb * defaultLabelProb;

			for (int i = 0; i < this.predictions.length; i++) {
				this.predictions[i] = defaultPredProb;
				for (int j = 0; j < this.labels.length; j++) {
					this.pred_label[i][j] = defaultPredLabelProb;
				}
			}
			for (int j = 0; j < this.labels.length; j++) {
				this.labels[j] = defaultLabelProb;
			}
		}
	}
}
