package com.rapidminer.operator.learner.meta;

import java.util.HashMap;
import java.util.Map;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeValueFilterSingleCondition;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;

public class CreateCombinedModelOnClusters extends AbstractMetaLearner {
	public CreateCombinedModelOnClusters( OperatorDescription description ) {
		super(description);
	}

	@Override
	public Model learn(ExampleSet exampleSet) throws OperatorException {
		Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
		if ( clusterAttribute == null ) {
			// if clusterAttribute is null, the model obviously does not create a cluster attribute but
			// stores the cluster as label. That will not work, because the label is needed as "real"
			// label for classification
			throw new OperatorException("cluster must be stored as special cluster attribute, not as label");
		}
		
		Map<String,Model> models = new HashMap<String,Model>();
		NominalMapping clusterValues = clusterAttribute.getMapping();		
		for (int currentClusterIdx = 0; currentClusterIdx < clusterValues.size(); ++currentClusterIdx ) {
			String currentClusterName = clusterValues.mapIndex(currentClusterIdx);
			AttributeValueFilterSingleCondition condition = new AttributeValueFilterSingleCondition(
					clusterAttribute, 
					AttributeValueFilterSingleCondition.EQUALS, 
					currentClusterName);
			ConditionedExampleSet currentClusterSet = new ConditionedExampleSet(exampleSet, condition);
			if ( currentClusterSet.size() > 0 ) {
				Model currentModel = applyInnerLearner(currentClusterSet);
				models.put(currentClusterName, currentModel);
			}
			else {
				models.put(currentClusterName, null);
			}
		}
		
		CombinedModelOnCluster combinedModel = new CombinedModelOnCluster(exampleSet, models);
		return combinedModel;
	}

	@Override
	public boolean supportsCapability(OperatorCapability lc) {
		if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES)
			return true;
		if (lc == OperatorCapability.BINOMINAL_LABEL)
			return true;
		if (lc == OperatorCapability.NUMERICAL_LABEL)
			return true;
		if (lc == OperatorCapability.WEIGHTED_EXAMPLES)
			return true;
		if (lc == OperatorCapability.FORMULA_PROVIDER)
			return true;
		return false;
	}
}
