/**
 * 
 */
package com.rapidminer.operator;

import java.util.HashMap;
import java.util.Map;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.tools.Ontology;

/**
 * @author mhelf
 *
 */
public class ExampleSet2DiscretizationModel extends Operator {

	public static final String PORT_MODEL_OUTPUT = "discretization_model";
	public static final String PORT_EXAMPLESET_INPUT = "example_set";
	
	private OutputPort modelOuput = getOutputPorts().createPort(PORT_MODEL_OUTPUT);
	private InputPort exampleSetInput = getInputPorts().createPort(PORT_EXAMPLESET_INPUT);

	
	/**
	 * @param description
	 */
	public ExampleSet2DiscretizationModel(OperatorDescription description) {
		super(description);
	}
	
	@Override
	public void doWork() throws OperatorException {
		ExampleSet examples = exampleSetInput.getData();
		if ( examples == null ) {
			throw new OperatorException("no example set on input port");
		}
		Attribute nameAttribute = examples.getAttributes().getSpecial("attribute_name");
		if (  nameAttribute == null ) {
			throw new OperatorException("input does not contain a special 'attribute_name' attribute");
		}
		if ( examples.size() != 1 ) {
			throw new OperatorException("input must contain exactly one example");
		}
		
		// read binning boundaries
		double[] limits = new double[examples.getAttributes().size()+1]; // +1, because positive infinity is appended to the list
		Example example = examples.getExample(0);
		{
			int i = 0;
			for ( Attribute attribute : example.getAttributes() ) {
				if ( examples.getAttributes().getRole(attribute).isSpecial() == false ) {
					limits[i] = example.getValue(attribute);
					++i;
				}
			}
		}
		limits[limits.length-1] = Double.POSITIVE_INFINITY;
		
		// create an empty example set which contains the binning attribute to deliver it to the discretization model		
		ExampleTable table = new MemoryExampleTable();
		Attribute binningAttribute = AttributeFactory.createAttribute(example.getNominalValue(nameAttribute), Ontology.REAL);
		table.addAttribute( binningAttribute );
		ExampleSet dummyExampleSet = table.createExampleSet();
		
		DiscretizationModel model = new DiscretizationModel(dummyExampleSet);
		Map<Attribute, double[]> rangesMap = new HashMap<Attribute, double[]>();
		rangesMap.put(binningAttribute, limits);
		model.setRanges(rangesMap, "bin", DiscretizationModel.RANGE_NAME_INTERVAL, -1);

		modelOuput.deliver(model);
	}

}
