/**
 * 
 */
package com.rapidminer.operator;

import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.container.Tupel;

/**
 * @author mhelf
 *
 */
public class DiscretizationModel2ExampleSet extends Operator {
	
	public static final String PORT_MODEL_INPUT = "discretization_model";
	public static final String PORT_EXAMPLESET_OUTPUT = "example_set";
	
	private InputPort modelInput = getInputPorts().createPort(PORT_MODEL_INPUT);
	private OutputPort exampleSetOutput = getOutputPorts().createPort(PORT_EXAMPLESET_OUTPUT);

	/**
	 * @param description
	 */
	public DiscretizationModel2ExampleSet(OperatorDescription description) {
		super(description);
	}
	
	@Override
	public void doWork() throws OperatorException {
		DiscretizationModel model = modelInput.getDataOrNull();
		if (model == null) {
			throw new OperatorException("no data is delivered to " + PORT_MODEL_INPUT + " or it is not a DiscretizationModel");
		}
		Map<String, SortedSet<Tupel<Double, String>>> allRanges = model.getRanges();
		
		if ( allRanges.size() != 1 ) {
			throw new OperatorException("DiscretizationModel must contain exactly one attribute, but it contains " + allRanges.size() + " attributes.");
		}		
		SortedSet<Tupel<Double, String>> ranges = allRanges.values().iterator().next();		
		
		// create ExampleSet:
		MemoryExampleTable table = new MemoryExampleTable(new LinkedList<Attribute>());
		DataRowFactory rowFactory = new DataRowFactory(DataRowFactory.TYPE_DOUBLE_ARRAY, '.');
		Double[] limits = new Double[ranges.size()];
		{
			int i = 0;
			for (Tupel<Double, String> bin : ranges ) {
				if ( i < ranges.size()-1 ) { // do not add the last limit (which is always positive infinity)					
					table.addAttribute( AttributeFactory.createAttribute("limit_" + (i+1), Ontology.REAL) );
					limits[i] = bin.getFirst();
					++i;
				}
			}
		}
		Attribute attributeName = AttributeFactory.createAttribute("binning_attribute", Ontology.NOMINAL);
		table.addAttribute( attributeName );		
		limits[limits.length-1] = 0.0;
		DataRow row = rowFactory.create(limits, table.getAttributes());
		table.addDataRow(row);
		ExampleSet result = table.createExampleSet();
		result.getAttributes().setSpecialAttribute(attributeName, "attribute_name");
		Example e = result.getExample(0);
		e.setValue(attributeName, model.getTrainingHeader().getAttributes().iterator().next().getName());
		exampleSetOutput.deliver( result );
	}
}
