/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.operator.tools;

import java.util.LinkedList;
import java.util.List;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;

/**
 * This operator will log a parameter value to the console
 * 
 * @author Sebastian Land, Sebastian Loh
 *
 */
public class ConsolePrintOperator extends Operator {

	public static final String PARAMETER_LOG_VALUE = "log_value";
	
	private DummyPortPairExtender dummyPorts = new DummyPortPairExtender("through", getInputPorts(), getOutputPorts());
	
	public ConsolePrintOperator(OperatorDescription description) {
		super(description);
		
		// start extender
		dummyPorts.start();
		
		// meta data transformation
		getTransformer().addRule(dummyPorts.makePassThroughRule());
	}

	
	@Override
	public void doWork() throws OperatorException {
		String value = getParameterAsString(PARAMETER_LOG_VALUE);
		this.getLogger().info(value);
		dummyPorts.passDataThrough();
	}
	
	@Override
	public List<ParameterType> getParameterTypes() {
		List<ParameterType> types = new LinkedList<ParameterType>();
		types.add(new ParameterTypeString(PARAMETER_LOG_VALUE, "This value will be logged to the console", false, false));

		return types;
	}
	
}
