/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
/**
 * @author Simon Fischer
 */
public class MultiOutputPortPairExtender extends MultiPortPairExtender<InputPort,OutputPort> {

	public MultiOutputPortPairExtender(String name, Ports<InputPort> singlePorts, Ports<OutputPort>[] multiPortsList) {
		super(name, singlePorts, multiPortsList);
	}
	
	public MDTransformationRule makePassThroughRule() {
		return new MDTransformationRule() {
			@Override
			public void transformMD() {
				for (MultiPortPair mpp : getManagedPairs()) {
					MetaData md = mpp.singlePort.getMetaData();
					for (OutputPort port : mpp.multiPorts) {
						port.deliverMD(md);
					}
				}
			}			
		};
	}
	
	public void passDataThrough() {
		for (MultiPortPair mpp : getManagedPairs()) {
			IOObject data = mpp.singlePort.getAnyDataOrNull();
			for (OutputPort port : mpp.multiPorts) {
				port.deliver(data);
			}
		}
	}
}
