/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import javax.swing.JComponent;

import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositoryLocationChooser;

/**
 * This is a WizardStep for selecting a repository location.
 * @author Tobias Malbrecht, Sebastian Land
 */
public class RepositoryLocationSelectionWizardStep extends WizardStep {

	private final RepositoryLocationChooser locationChooser;
	
	/**
	 * This constructor is only left for compatibility issues with the paren extension. Hence it doesn't make any sense
	 * please refer to the {@link #RepositoryLocationSelectionWizardStep(AbstractWizard, String)} Constructor instead.
	 */
	@Deprecated
	public RepositoryLocationSelectionWizardStep(String notUsed, AbstractWizard parent, RepositoryLocation notUsedToo, String initialValue) {
		this(parent, initialValue);
	}
	
	/**
	 * Constructor for this wizard step.
	 */
	public RepositoryLocationSelectionWizardStep(AbstractWizard parent, String initialValue) {
		super("select_repository_location");
		this.locationChooser = new RepositoryLocationChooser(parent, null, initialValue);
		this.locationChooser.addChangeListener(parent);
	}

	@Override
	protected boolean canGoBack() {
		return true;
	}
	
	@Override
	protected boolean canProceed() {
		return locationChooser.hasSelection();
	}

	@Override
	protected JComponent getComponent() {
		return locationChooser;
	}
	
	public String getRepositoryLocation() {
		try {
			return locationChooser.getRepositoryLocation();
		} catch (MalformedRepositoryLocationException e) {
			// Only queried if hasSelection returned true, so we will not have an exception.
			throw new RuntimeException(e);
		}
	}
}
