/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.gui.plotter.mathplot;

import org.math.plot.Plot2DPanel;
import org.math.plot.PlotPanel;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;


/** The abstract super class for all 2D plotters using the JMathPlot library. 
 *  
 *  @author Ingo Mierswa
 */
public abstract class JMathPlotter2D extends JMathPlotter {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2547520708373816637L;

	public JMathPlotter2D(PlotterConfigurationModel settings) {
		super(settings);
	}
	
	public JMathPlotter2D(PlotterConfigurationModel settings, DataTable dataTable) {
		super(settings, dataTable);
	}
	
	@Override
	protected PlotPanel createPlotPanel() { return new Plot2DPanel(); }
	
	@Override
	public int getNumberOfOptionIcons() {
		return 4;
	}
}
