/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.gui.plotter.conditions;

import com.rapidminer.datatable.DataTable;

/**
 * This condition class can be used to indicate that a plotter is only available for certain types
 * of data tables, e.g. only for tables with a maximal number of columns. 
 * 
 * @author Ingo Mierswa
 */
public interface PlotterCondition {

    public boolean acceptDataTable(DataTable dataTable);
 
    public String getRejectionReason(DataTable dataTable);
}
