/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapid_i.deployment.update.client;

import java.io.IOException;
import java.io.InputStream;

import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;

/**  Stream reporting the amount of read bytes to ProgressListener
 * 
 * @author Simon Fischer
 * */
public class ProgressReportingInputStream extends InputStream {

	private InputStream parent;

	private ProgressListener listener;
	private int showMin;
	private int showMax;	
	private int streamLength;

	private int readBytes = 0;
	private int lastReportedValue = Integer.MIN_VALUE;

	public ProgressReportingInputStream(InputStream in,	ProgressListener listener, int minProgress, int maxProgress, int streamLength) {
		this.parent = in;
		this.listener = listener;
		this.showMin = minProgress;
		this.showMax = maxProgress;
		this.streamLength = streamLength;
	}

	@Override
	public int read() throws IOException {
		int b = parent.read();
		report(1);		
		return b;
	}

	@Override
	public int read(byte[] b, int off, int len) throws IOException {
		int result = parent.read(b, off, len);
		report(result);
		return result;
	}

	@Override
	public int read(byte[] b) throws IOException {
		int result = parent.read(b);
		report(result);
		return result;
	}

	private void report(int increment) {
		if (increment > 0) {
			readBytes += increment;
			int completed = showMin + (showMax-showMin) * readBytes / streamLength;
			if (completed != lastReportedValue) {
				if (listener != null) {
					listener.setCompleted(completed);
					listener.setMessage(Tools.formatBytes(readBytes) + "/" +Tools.formatBytes(streamLength));
				}
				lastReportedValue = completed;
			}
		}
	}


}
