/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.tools.math.similarity.divergences;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.BregmanDivergence;

/**
 * The &quot;Squared Euclidean distance &quot;.
 * 
 * @author Regina Fritsch
 */
public class SquaredEuclideanDistance extends BregmanDivergence{

	private static final long serialVersionUID = -1506627696517615682L;

	@Override
	public double calculateDistance(double[] value1, double[] value2) {
		double result = 0;
		for (int i = 0; i < value1.length ; i++) {
			double diff = value1[i] - value2[i];
			result += diff * diff;
		}
		return result;
	}

	@Override
	public void init(ExampleSet exampleSet) throws OperatorException {
		Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
	}

	@Override
	public String toString() {
		return "Squared euclidean distance";
	}
}
