/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.repository.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.components.DropDownButton;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.BlobImportWizard;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;

/**
 * A component to browse through repositories.
 * 
 * @author Simon Fischer
 */
public class RepositoryBrowser extends JPanel implements Dockable {

	private static final long serialVersionUID = 1L;

	public static final Action ADD_REPOSITORY_ACTION = new ResourceAction(true, "add_repository") {
		private static final long serialVersionUID = 1L;
		@Override
		public void actionPerformed(ActionEvent e) {
			addRepository();
		}			
	};
	
	private final RepositoryTree tree;
	
	public RepositoryBrowser() {
		tree = new RepositoryTree();
		tree.addRepositorySelectionListener(new RepositorySelectionListener() {			
			@Override
			public void repositoryLocationSelected(RepositorySelectionEvent e) {
				Entry entry = e.getEntry();
				if (entry instanceof ProcessEntry) {
					RepositoryTree.openProcess((ProcessEntry)entry);												
				} else if (entry instanceof IOObjectEntry) {
					RepositoryTree.showAsResult((IOObjectEntry) entry);
				}				
			}
		});
				
		setLayout(new BorderLayout());
		JToolBar toolBar = new ExtendedJToolBar();
		toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
		toolBar.add(ADD_REPOSITORY_ACTION);
		(new DropDownButton(new ResourceActionAdapter(true, "import")) {
			private static final long serialVersionUID = -5482452738124971463L;

			@Override
			protected JPopupMenu getPopupMenu() {
				JPopupMenu menu = new JPopupMenu();
				menu.add(RapidMinerGUI.getMainFrame().IMPORT_CSV_FILE_ACTION);
				menu.add(RapidMinerGUI.getMainFrame().IMPORT_EXCEL_FILE_ACTION);
				menu.add(RapidMinerGUI.getMainFrame().IMPORT_ACCESS_FILE_ACTION);
				menu.add(RapidMinerGUI.getMainFrame().IMPORT_DATABASE_TABLE_ACTION);
				menu.add(BlobImportWizard.IMPORT_BLOB_ACTION);
				return menu;
			}
		}).addToToolBar(toolBar);
		toolBar.add(tree.OPEN_ACTION);
		toolBar.add(tree.REFRESH_ACTION);
		toolBar.add(tree.CREATE_FOLDER_ACTION);
		add(toolBar, BorderLayout.NORTH);
		JScrollPane scrollPane = new ExtendedJScrollPane(tree);
		scrollPane.setBorder(null);
		add(scrollPane, BorderLayout.CENTER);		
	}

	private static void addRepository() {
		NewRepositoryDialog.createNew();						
	}

	public static final String REPOSITORY_BROWSER_DOCK_KEY = "repository_browser";
	private final DockKey DOCK_KEY = new ResourceDockKey(REPOSITORY_BROWSER_DOCK_KEY);
	{
		DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
	}
	@Override
	public Component getComponent() {
		return this;
	}

	@Override
	public DockKey getDockKey() {
		return DOCK_KEY;
	}
}
