/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.gui.tools.dialogs;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;


/**
 * A dialog to set a single parameter.
 * 
 * @author Tobias Malbrecht
 */
public class SetParameterDialog extends ButtonDialog {
	private static final long serialVersionUID = 1484984144870499737L;

	private final Operator operator;
	
	private final ParameterType type;
	
	private final PropertyValueCellEditor editor;
	
	private boolean canceled = false;

	public SetParameterDialog(final Operator operator, final ParameterType type) {
		super("set_parameter", new Object[] { type.getKey().replace('_', ' ') });
		this.operator = operator;
		this.type = type;
		editor = PropertyPanel.instantiateValueCellEditor(type, operator);
		editor.addCellEditorListener(new CellEditorListener() {				
			@Override
			public void editingCanceled(ChangeEvent e) {
				cancel();
			}
			@Override
			public void editingStopped(ChangeEvent e) {
				// necessary since cell editors define focus listener
				// which fires editing stopped on focus lost
				if (!canceled) {
					ok();
				} else {
					cancel();
				}
			}
		});
		JComponent editorComponent = (JComponent) editor.getTableCellEditorComponent(null, type.getDefaultValue(), false, 0, 1);
		editorComponent.addKeyListener(new KeyListener() {

			@Override
			public void keyPressed(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
					canceled = true;
				}
			}

			@Override
			public void keyReleased(KeyEvent e) {}

			@Override
			public void keyTyped(KeyEvent e) {}
			
		});
		JButton okButton = makeOkButton();
		layoutDefault(editorComponent, okButton, makeCancelButton());
		getRootPane().setDefaultButton(okButton);
	}
	
	@Override
	protected String getInfoText() {
		return type.getDescription();
	}
	
	@Override
	protected void ok() {
		Object value = editor.getCellEditorValue();
		if (value != null && ((String) value).length() != 0) {
			operator.setParameter(type.getKey(), (String) value);
			super.ok();
		}
	}
}
