/*
 *  RapidMiner
 *
 *  Copyright (C) 2001-2010 by Rapid-I and the contributors
 *
 *  Complete list of developers available at our web site:
 *
 *       http://rapid-i.com
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package com.rapidminer.generator;

import com.rapidminer.tools.LogService;

/**
 * This class has two numerical input attributes and one output attribute.
 * Calculates the power of the input attribute to the second.
 * 
 * @author Ingo Mierswa
 */
public class PowerGenerator extends BinaryNumericalGenerator {

	public PowerGenerator() {}

	@Override
	public FeatureGenerator newInstance() {
		return new PowerGenerator();
	}

	@Override
	public boolean isCommutative() {
		return false;
	}

	@Override
	public boolean isSelfApplicable() {
		return true;
	}

	@Override
	public double calculateValue(double value1, double value2) {
		return Math.pow(value1, value2);
	}

	@Override
	public void setFunction(String name) {
		if (!name.equals("^"))
			LogService.getGlobal().log("Illegal function name '" + name + "' for " + getClass().getName() + ".", LogService.ERROR);
	}

	@Override
	public String getFunction() {
		return "^";
	}
}
