/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.position;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public final class PositionFilter
extends TokenFilter {
    private int positionIncrement = 0;
    private boolean firstTokenPositioned = false;
    private PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);

    public PositionFilter(TokenStream input) {
        super(input);
    }

    public PositionFilter(TokenStream input, int positionIncrement) {
        this(input);
        this.positionIncrement = positionIncrement;
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.firstTokenPositioned) {
                this.posIncrAtt.setPositionIncrement(this.positionIncrement);
            } else {
                this.firstTokenPositioned = true;
            }
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.firstTokenPositioned = false;
    }
}

