/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class DelimitedPayloadTokenFilter
extends TokenFilter {
    public static final char DEFAULT_DELIMITER = '|';
    protected char delimiter = (char)124;
    protected TermAttribute termAtt = this.addAttribute(TermAttribute.class);
    protected PayloadAttribute payAtt = this.addAttribute(PayloadAttribute.class);
    protected PayloadEncoder encoder;

    protected DelimitedPayloadTokenFilter(TokenStream input) {
        this(input, '|', new IdentityEncoder());
    }

    public DelimitedPayloadTokenFilter(TokenStream input, char delimiter, PayloadEncoder encoder) {
        super(input);
        this.delimiter = delimiter;
        this.encoder = encoder;
    }

    public boolean incrementToken() throws IOException {
        boolean result = false;
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.termBuffer();
            int length = this.termAtt.termLength();
            boolean seen = false;
            for (int i = 0; i < length; ++i) {
                if (buffer[i] != this.delimiter) continue;
                this.termAtt.setTermBuffer(buffer, 0, i);
                this.payAtt.setPayload(this.encoder.encode(buffer, i + 1, length - (i + 1)));
                seen = true;
                break;
            }
            if (!seen) {
                this.payAtt.setPayload(null);
            }
            result = true;
        }
        return result;
    }
}

