/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.AbstractWeightedPerformanceMeasures;
import com.rapidminer.tools.LogService;
import java.util.Iterator;

public class StandardWeightedPerformanceMeasures
extends AbstractWeightedPerformanceMeasures {
    public StandardWeightedPerformanceMeasures(ExampleSet exampleSet) throws OperatorException {
        super(exampleSet);
    }

    @Override
    protected void initStatistics(ExampleSet exampleSet) {
        Iterator reader = exampleSet.iterator();
        double sumOfWeights = 0.0;
        while (reader.hasNext()) {
            Example exa = (Example)reader.next();
            double exaW = exa.getWeight();
            sumOfWeights += exaW;
            int eLabel = (int)exa.getLabel();
            int ePred = (int)exa.getPredictedLabel();
            if (ePred >= 0 && ePred < this.predictions.length && eLabel >= 0 && eLabel < this.labels.length) {
                double[] dArray = this.unweighted_num_pred_label[ePred];
                int n = eLabel;
                dArray[n] = dArray[n] + 1.0;
                int n2 = eLabel;
                this.labels[n2] = this.labels[n2] + exaW;
                int n3 = ePred;
                this.predictions[n3] = this.predictions[n3] + exaW;
                double[] dArray2 = this.pred_label[ePred];
                int n4 = eLabel;
                dArray2[n4] = dArray2[n4] + exaW;
                continue;
            }
            exa.setWeight(0.0);
            exa.setLabel(0.0);
            exa.setPredictedLabel(0.0);
            LogService.getGlobal().log("WeightedPerformanceMeasures: Deleted example with illegal label or prediction (" + eLabel + ", " + ePred + ")!", 5);
        }
        if (sumOfWeights > 0.0) {
            for (int i = 0; i < this.predictions.length; ++i) {
                int n = i;
                this.predictions[n] = this.predictions[n] / sumOfWeights;
                int j = 0;
                while (j < this.labels.length) {
                    double[] dArray = this.pred_label[i];
                    int n5 = j++;
                    dArray[n5] = dArray[n5] / sumOfWeights;
                }
            }
            int j = 0;
            while (j < this.labels.length) {
                int n = j++;
                this.labels[n] = this.labels[n] / sumOfWeights;
            }
        } else {
            double defaultPredProb = 1.0 / (double)this.predictions.length;
            double defaultLabelProb = 1.0 / (double)this.labels.length;
            double defaultPredLabelProb = defaultPredProb * defaultLabelProb;
            for (int i = 0; i < this.predictions.length; ++i) {
                this.predictions[i] = defaultPredProb;
                for (int j = 0; j < this.labels.length; ++j) {
                    this.pred_label[i][j] = defaultPredLabelProb;
                }
            }
            for (int j = 0; j < this.labels.length; ++j) {
                this.labels[j] = defaultLabelProb;
            }
        }
    }
}

