/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.AbstractWeightedPerformanceMeasures;
import com.rapidminer.tools.LogService;
import java.util.Iterator;

public class FuzzyWeightedPerformanceMeasures
extends AbstractWeightedPerformanceMeasures {
    public FuzzyWeightedPerformanceMeasures(ExampleSet exampleSet) throws OperatorException {
        super(exampleSet);
    }

    @Override
    protected void initStatistics(ExampleSet exampleSet) {
        Iterator reader = exampleSet.iterator();
        double sumOfWeights = 0.0;
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        String positiveClass = labelAttribute.getMapping().getPositiveString();
        String negativeClass = labelAttribute.getMapping().getNegativeString();
        int positiveIdx = labelAttribute.getMapping().getPositiveIndex();
        int negativeIdx = labelAttribute.getMapping().getNegativeIndex();
        while (reader.hasNext()) {
            Example exa = (Example)reader.next();
            double exaW = exa.getWeight();
            int eLabel = (int)exa.getLabel();
            int ePred = (int)exa.getPredictedLabel();
            double positiveConfidence = exa.getConfidence(positiveClass);
            double negativeConfidence = exa.getConfidence(negativeClass);
            sumOfWeights += exaW;
            if (ePred >= 0 && ePred < this.predictions.length && eLabel >= 0 && eLabel < this.labels.length) {
                double[] dArray = this.unweighted_num_pred_label[positiveIdx];
                int n = eLabel;
                dArray[n] = dArray[n] + positiveConfidence;
                double[] dArray2 = this.unweighted_num_pred_label[negativeIdx];
                int n2 = eLabel;
                dArray2[n2] = dArray2[n2] + negativeConfidence;
                int n3 = eLabel;
                this.labels[n3] = this.labels[n3] + exaW;
                int n4 = positiveIdx;
                this.predictions[n4] = this.predictions[n4] + exaW * positiveConfidence;
                int n5 = negativeIdx;
                this.predictions[n5] = this.predictions[n5] + exaW * negativeConfidence;
                double[] dArray3 = this.pred_label[positiveIdx];
                int n6 = eLabel;
                dArray3[n6] = dArray3[n6] + exaW * positiveConfidence;
                double[] dArray4 = this.pred_label[negativeIdx];
                int n7 = eLabel;
                dArray4[n7] = dArray4[n7] + exaW * negativeConfidence;
                continue;
            }
            exa.setWeight(0.0);
            exa.setLabel(0.0);
            exa.setPredictedLabel(0.0);
            LogService.getGlobal().log("WeightedPerformanceMeasures: Deleted example with illegal label or prediction (" + eLabel + ", " + ePred + ")!", 5);
        }
        if (sumOfWeights > 0.0) {
            for (int i = 0; i < this.predictions.length; ++i) {
                int n = i;
                this.predictions[n] = this.predictions[n] / sumOfWeights;
                int j = 0;
                while (j < this.labels.length) {
                    double[] dArray = this.pred_label[i];
                    int n8 = j++;
                    dArray[n8] = dArray[n8] / sumOfWeights;
                }
            }
            int j = 0;
            while (j < this.labels.length) {
                int n = j++;
                this.labels[n] = this.labels[n] / sumOfWeights;
            }
        } else {
            double defaultPredProb = 1.0 / (double)this.predictions.length;
            double defaultLabelProb = 1.0 / (double)this.labels.length;
            double defaultPredLabelProb = defaultPredProb * defaultLabelProb;
            for (int i = 0; i < this.predictions.length; ++i) {
                this.predictions[i] = defaultPredProb;
                for (int j = 0; j < this.labels.length; ++j) {
                    this.pred_label[i][j] = defaultPredLabelProb;
                }
            }
            for (int j = 0; j < this.labels.length; ++j) {
                this.labels[j] = defaultLabelProb;
            }
        }
    }
}

