/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeValueFilterSingleCondition;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.CombinedModelOnCluster;
import java.util.HashMap;

public class CreateCombinedModelOnClusters
extends AbstractMetaLearner {
    public CreateCombinedModelOnClusters(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
        if (clusterAttribute == null) {
            throw new OperatorException("cluster must be stored as special cluster attribute, not as label");
        }
        HashMap<String, Model> models = new HashMap<String, Model>();
        NominalMapping clusterValues = clusterAttribute.getMapping();
        for (int currentClusterIdx = 0; currentClusterIdx < clusterValues.size(); ++currentClusterIdx) {
            String currentClusterName = clusterValues.mapIndex(currentClusterIdx);
            AttributeValueFilterSingleCondition condition = new AttributeValueFilterSingleCondition(clusterAttribute, 4, currentClusterName);
            ConditionedExampleSet currentClusterSet = new ConditionedExampleSet(exampleSet, (Condition)condition);
            if (currentClusterSet.size() > 0) {
                Model currentModel = this.applyInnerLearner((ExampleSet)currentClusterSet);
                models.put(currentClusterName, currentModel);
                continue;
            }
            models.put(currentClusterName, null);
        }
        CombinedModelOnCluster combinedModel = new CombinedModelOnCluster(exampleSet, models);
        return combinedModel;
    }

    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.NUMERICAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.WEIGHTED_EXAMPLES) {
            return true;
        }
        return lc == OperatorCapability.FORMULA_PROVIDER;
    }
}

