/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeValueFilterSingleCondition;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CombinedModelOnCluster
extends AbstractModel {
    private static final long serialVersionUID = 2907982539494087150L;
    private Map<String, Model> models;

    public CombinedModelOnCluster(ExampleSet exampleSet, Map<String, Model> models) {
        super(exampleSet);
        this.models = models;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
        if (clusterAttribute == null) {
            throw new OperatorException("example set has no special cluster attribute");
        }
        LinkedList<ExampleSet> predictedExampleSets = new LinkedList<ExampleSet>();
        for (String currentClusterName : clusterAttribute.getMapping().getValues()) {
            Model model = this.models.get(currentClusterName);
            AttributeValueFilterSingleCondition condition = new AttributeValueFilterSingleCondition(clusterAttribute, 4, currentClusterName);
            ConditionedExampleSet currentClusterSet = new ConditionedExampleSet((ExampleSet)exampleSet.clone(), (Condition)condition);
            if (model != null && currentClusterSet.size() > 0) {
                ExampleSet predictedExampleSet = model.apply((ExampleSet)currentClusterSet);
                predictedExampleSets.add(predictedExampleSet);
                continue;
            }
            if (currentClusterSet.size() <= 0) continue;
            this.logWarning("The model for cluster '" + currentClusterName + "' is null. Examples in this cluster will be classified as unknown.");
        }
        return this.merge(predictedExampleSets);
    }

    ExampleSet merge(List<ExampleSet> allExampleSets) throws OperatorException {
        if (allExampleSets.size() == 0) {
            throw new MissingIOObjectException(ExampleSet.class);
        }
        ExampleSet firstSet = allExampleSets.get(0);
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        Iterator a = firstSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = (AttributeRole)a.next();
            Attribute attributeClone = (Attribute)role.getAttribute().clone();
            attributeList.add(attributeClone);
            if (!role.isSpecial()) continue;
            specialAttributes.put(attributeClone, role.getSpecialName());
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributeList);
        Iterator<ExampleSet> i = allExampleSets.iterator();
        DataRowFactory factory = new DataRowFactory(0, '.');
        while (i.hasNext()) {
            ExampleSet currentExampleSet = i.next();
            Iterator e = currentExampleSet.iterator();
            while (e.hasNext()) {
                DataRow dataRow = ((Example)e.next()).getDataRow();
                String[] newData = new String[attributeList.size()];
                Iterator newAttributes = attributeList.iterator();
                int counter = 0;
                while (newAttributes.hasNext()) {
                    Attribute newAttribute = (Attribute)newAttributes.next();
                    Attribute oldAttribute = currentExampleSet.getAttributes().get(newAttribute.getName());
                    double oldValue = dataRow.get(oldAttribute);
                    newData[counter] = Double.isNaN(oldValue) ? "?" : (newAttribute.isNominal() ? oldAttribute.getMapping().mapIndex((int)oldValue) : oldValue + "");
                    ++counter;
                }
                exampleTable.addDataRow(factory.create(newData, exampleTable.getAttributes()));
            }
        }
        ExampleSet resultSet = exampleTable.createExampleSet(specialAttributes);
        return resultSet;
    }
}

