/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.AbstractBayesianBoosting;
import com.rapidminer.operator.learner.meta.AbstractWeightedPerformanceMeasures;
import com.rapidminer.operator.learner.meta.BayBoostBaseModelInfo;
import com.rapidminer.operator.learner.meta.BayBoostModel;
import com.rapidminer.operator.learner.meta.ContingencyMatrix;
import com.rapidminer.operator.learner.meta.FuzzyWeightedPerformanceMeasures;
import com.rapidminer.operator.learner.meta.StandardWeightedPerformanceMeasures;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BayesianBoostingSql
extends AbstractBayesianBoosting {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_NEW_SAMPLE_INTERVAL = "new_sample_interval";
    public static final String PARAMETER_MODEL_OUTPUT_INTERVAL = "model_output_interval";
    public static final double MIN_ADVANTAGE = 0.001;
    protected OutputPort modelCollectionOutput;

    public BayesianBoostingSql(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueDouble("performance", "The performance."){

            public double getDoubleValue() {
                return BayesianBoostingSql.this.performance;
            }
        });
        this.modelCollectionOutput = (OutputPort)this.getOutputPorts().createPort("model_collection_output");
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.readOptionalParameters();
        double[] classPriors = this.prepareWeights(exampleSet);
        double maxPrior = Double.NEGATIVE_INFINITY;
        double sumPriors = 0.0;
        for (int i = 0; i < classPriors.length; ++i) {
            if (classPriors[i] > maxPrior) {
                maxPrior = classPriors[i];
            }
            sumPriors += classPriors[i];
        }
        BayBoostModel model = Tools.isEqual((double)sumPriors, (double)maxPrior) ? new BayBoostModel(exampleSet, new Vector(), classPriors) : this.trainBoostingModel(exampleSet, classPriors);
        if (this.oldWeights != null) {
            Iterator reader = exampleSet.iterator();
            int i = 0;
            while (reader.hasNext() && i < this.oldWeights.length) {
                ((Example)reader.next()).setWeight(this.oldWeights[i++]);
            }
        } else {
            Attribute weight = exampleSet.getAttributes().getWeight();
            exampleSet.getAttributes().remove(weight);
            exampleSet.getExampleTable().removeAttribute(weight);
        }
        return model;
    }

    @Override
    protected BayBoostModel trainBoostingModel(ExampleSet trainingSet, double[] classPriors) throws OperatorException {
        this.fuzzyReweighting = this.getParameterAsBoolean("fuzzy_reweighting");
        try {
            this.pmClass = this.getParameterAsBoolean("fuzzy_partition_sizes") ? FuzzyWeightedPerformanceMeasures.class : StandardWeightedPerformanceMeasures.class;
            this.pmConstructor = this.pmClass.getConstructor(ExampleSet.class);
        }
        catch (Exception e) {
            this.pmConstructor = null;
        }
        Vector<BayBoostBaseModelInfo> modelInfo = new Vector<BayBoostBaseModelInfo>();
        this.applyPriorModel(trainingSet, modelInfo);
        double splitRatio = this.getParameterAsDouble("use_subset_for_training");
        boolean bootstrap = splitRatio > 0.0 && splitRatio < 1.0;
        this.log(bootstrap ? "Bootstrapping enabled." : "Bootstrapping disabled.");
        boolean allowSkew = this.getParameterAsBoolean("allow_marginal_skews");
        SplittedExampleSet splittedSet = null;
        if (bootstrap) {
            splittedSet = new SplittedExampleSet(trainingSet, splitRatio, 1, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        }
        int newSampleInterval = this.getParameterAsInt(PARAMETER_NEW_SAMPLE_INTERVAL);
        int modelOutputInterval = this.getParameterAsInt(PARAMETER_MODEL_OUTPUT_INTERVAL);
        IOObjectCollection modelCollection = new IOObjectCollection();
        int iterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        for (int i = 0; i < iterations; ++i) {
            AbstractWeightedPerformanceMeasures wp;
            Model model;
            this.currentIteration = i;
            if ((this.currentIteration + 1) % newSampleInterval == 0) {
                trainingSet = this.getNewSample(modelInfo);
            }
            ExampleSet iterationSet = (ExampleSet)trainingSet.clone();
            if (bootstrap) {
                splittedSet.selectSingleSubset(0);
                model = this.trainBaseModel((ExampleSet)splittedSet);
                iterationSet = model.apply(iterationSet);
                wp = this.reweightExamplesWrapper((ExampleSet)splittedSet, bootstrap);
                try {
                    wp = (AbstractWeightedPerformanceMeasures)this.pmConstructor.newInstance(splittedSet);
                    this.performance = (Double)this.pmClass.getMethod("reweightExamples", ExampleSet.class, ContingencyMatrix.class, Boolean.TYPE, Boolean.TYPE).invoke(null, splittedSet, wp.getContingencyMatrix(), allowSkew, this.fuzzyReweighting);
                }
                catch (Exception e) {
                    throw new OperatorException("cannot call reweightExamples");
                }
            } else {
                model = this.trainBaseModel(iterationSet);
                iterationSet = model.apply(iterationSet);
                wp = this.reweightExamplesWrapper(iterationSet, bootstrap);
            }
            PredictionModel.removePredictedLabel((ExampleSet)iterationSet);
            if (classPriors.length == 2) {
                // empty if block
            }
            if (modelOutputInterval > 0 && (this.currentIteration + 1) % modelOutputInterval == 0) {
                Vector<BayBoostBaseModelInfo> currentModelInfo = new Vector<BayBoostBaseModelInfo>();
                for (BayBoostBaseModelInfo c : modelInfo) {
                    currentModelInfo.add(c);
                }
                modelCollection.add((IOObject)new BayBoostModel(trainingSet, currentModelInfo, classPriors));
            }
            if (wp.getNumberOfNonEmptyClasses() < 2) {
                modelInfo.add(new BayBoostBaseModelInfo(model, wp.getContingencyMatrix()));
                break;
            }
            ContingencyMatrix cm = wp.getContingencyMatrix();
            modelInfo.add(new BayBoostBaseModelInfo(model, cm));
            if (!this.isModelUseful(cm)) {
                this.log("Discard model because of low advantage on training data.");
                modelInfo.remove(modelInfo.size() - 1);
                break;
            }
            if (this.performance == 0.0) break;
            this.inApplyLoop();
        }
        this.modelCollectionOutput.deliver((IOObject)modelCollection);
        return new BayBoostModel(trainingSet, modelInfo, classPriors);
    }

    private boolean isModelUseful(ContingencyMatrix cm) {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_ITERATIONS, "The maximum number of iterations.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NEW_SAMPLE_INTERVAL, "Specifies how often a new sample is drawn via the inner process (each X iterations)", 1, Integer.MAX_VALUE));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_MODEL_OUTPUT_INTERVAL, "Specifies how often the current ensemble is output (each X iterations, 0 for never)", 0, Integer.MAX_VALUE));
        return types;
    }
}

