/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.ContingencyMatrix;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.util.Iterator;

public abstract class AbstractWeightedPerformanceMeasures {
    public static final double RULE_DOES_NOT_APPLY = Double.NaN;
    protected double[] predictions;
    protected double[] labels;
    protected double[][] pred_label;
    protected double[][] unweighted_num_pred_label;

    public AbstractWeightedPerformanceMeasures(ExampleSet exampleSet) throws OperatorException {
        int numberOfClasses = exampleSet.getAttributes().getLabel().getMapping().getValues().size();
        this.labels = new double[numberOfClasses];
        this.predictions = new double[numberOfClasses];
        this.pred_label = new double[this.predictions.length][this.labels.length];
        this.unweighted_num_pred_label = new double[this.predictions.length][this.labels.length];
        this.initStatistics(exampleSet);
    }

    protected abstract void initStatistics(ExampleSet var1);

    public double[] getCoveredExamplesNumForPred(int prediction) {
        int length = this.unweighted_num_pred_label.length;
        if (prediction >= 0 && prediction < length) {
            return this.unweighted_num_pred_label[prediction];
        }
        return new double[length];
    }

    public int getNumberOfLabels() {
        return this.labels.length;
    }

    public int getNumberOfPredictions() {
        return this.predictions.length;
    }

    public double getProbability(int label, int prediction) {
        return this.pred_label[prediction][label];
    }

    public double getProbabilityLabel(int label) {
        return this.labels[label];
    }

    public double getProbabilityPrediction(int premise) {
        return this.predictions[premise];
    }

    public double getLift(int label, int prediction) {
        double prLabel = this.getProbabilityLabel(label);
        double prPred = this.getProbabilityPrediction(prediction);
        double prJoint = this.getProbability(label, prediction);
        if (prPred == 0.0) {
            return Double.NaN;
        }
        if (prJoint == 0.0) {
            return 0.0;
        }
        if (Tools.isEqual((double)prJoint, (double)prPred)) {
            return Double.POSITIVE_INFINITY;
        }
        double lift = prJoint / (prLabel * prPred);
        return lift;
    }

    public double[] getPnRatios(int prediction) {
        double[] lifts = new double[this.labels.length];
        for (int i = 0; i < lifts.length; ++i) {
            int rapidMinerLabelIndex = i;
            double b = this.getLift(rapidMinerLabelIndex, prediction);
            if (b == 0.0 || b == Double.POSITIVE_INFINITY) {
                lifts[i] = b;
                continue;
            }
            double negLabel = 1.0 - this.getProbabilityLabel(rapidMinerLabelIndex);
            double probPred = this.getProbabilityPrediction(prediction);
            double probPredLabel = this.getProbability(rapidMinerLabelIndex, prediction);
            double negLabelPred = probPred - probPredLabel;
            double oppositeLift = negLabelPred / (negLabel * probPred);
            lifts[i] = b / oppositeLift;
        }
        return lifts;
    }

    public double[][] createLiftRatioMatrix() {
        int numPredictions = this.getNumberOfPredictions();
        double[][] liftRatioMatrix = new double[numPredictions][];
        for (int i = 0; i < numPredictions; ++i) {
            liftRatioMatrix[i] = this.getPnRatios(i);
        }
        return liftRatioMatrix;
    }

    public double[] getLabelPriors() {
        double[] priors = new double[this.getNumberOfLabels()];
        for (int i = 0; i < priors.length; ++i) {
            priors[i] = this.getProbabilityLabel(i);
        }
        return priors;
    }

    public int getNumberOfNonEmptyClasses() {
        int nonEmpty = 0;
        for (int i = 0; i < this.getNumberOfLabels(); ++i) {
            if (!(this.getProbabilityLabel(i) > 0.0)) continue;
            ++nonEmpty;
        }
        return nonEmpty;
    }

    public ContingencyMatrix getContingencyMatrix() {
        if (this.pred_label.length == 0 || this.pred_label[0].length == 0) {
            return new ContingencyMatrix(new double[0][0]);
        }
        double[][] matrix = new double[this.pred_label[0].length][this.pred_label.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                double predLabelJi = this.pred_label[j][i];
                if (Double.isNaN(predLabelJi) || predLabelJi < 0.0 || predLabelJi > 1.0) {
                    LogService.getGlobal().log("Found illegal value in contingency matrix!", 5);
                }
                matrix[i][j] = predLabelJi;
            }
        }
        return new ContingencyMatrix(matrix);
    }

    public static double reweightExamples(ExampleSet exampleSet, ContingencyMatrix cm, boolean allowMarginalSkews, boolean fuzzy) throws OperatorException {
        Iterator reader = exampleSet.iterator();
        double totalWeight = 0.0;
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        while (reader.hasNext()) {
            double newWeight;
            Example example = (Example)reader.next();
            int label = (int)example.getValue(labelAttribute);
            int predicted = (int)example.getValue(predictedLabel);
            double lift = AbstractWeightedPerformanceMeasures.getLiftForExample(example, cm);
            if (Double.isNaN(lift) || lift < 0.0) {
                LogService.getGlobal().log("Applied rule with an illegal lift of " + lift + " during reweighting!", 5);
                continue;
            }
            if (lift == 0.0 || Double.isInfinite(lift)) {
                example.setValue(weightAttribute, 0.0);
                continue;
            }
            double weight = example.getValue(weightAttribute);
            if (Double.isNaN(weight) || Double.isInfinite(weight) || weight < 0.0) {
                LogService.getGlobal().log("Found illegal weight: " + weight, 5);
                newWeight = 0.0;
            } else {
                if (weight == 0.0) continue;
                if (allowMarginalSkews) {
                    if (fuzzy) {
                        String positiveClass = labelAttribute.getMapping().getPositiveString();
                        String negativeClass = labelAttribute.getMapping().getNegativeString();
                        int positiveIdx = labelAttribute.getMapping().getPositiveIndex();
                        int negativeIdx = labelAttribute.getMapping().getNegativeIndex();
                        double positiveConfidence = example.getConfidence(positiveClass);
                        double negativeConfidence = example.getConfidence(negativeClass);
                        double prec_pos = cm.getPrecision(label, positiveIdx);
                        double prec_neg = cm.getPrecision(label, negativeIdx);
                        double beta_pos = (1.0 - prec_pos) / prec_pos;
                        double beta_neg = (1.0 - prec_neg) / prec_neg;
                        if (predicted == negativeIdx && (Double.isInfinite(beta_pos) || Double.isNaN(beta_pos))) {
                            negativeConfidence = 1.0;
                            positiveConfidence = 0.0;
                            beta_pos = 1.0;
                        } else if (predicted == positiveIdx && (Double.isInfinite(beta_neg) || Double.isNaN(beta_neg))) {
                            negativeConfidence = 0.0;
                            positiveConfidence = 1.0;
                            beta_neg = 1.0;
                        }
                        if (beta_pos <= 0.0 || beta_neg <= 0.0 || Double.isInfinite(beta_pos) || Double.isNaN(beta_pos) || Double.isInfinite(beta_neg) || Double.isNaN(beta_neg)) {
                            LogService.getGlobal().log("Reweighting uses invalid value: predicted is " + predicted + ", beta_pos is " + beta_pos + ", beta_neg is " + beta_neg, 5);
                        }
                        newWeight = weight * (positiveConfidence * Math.sqrt(beta_pos) + negativeConfidence * Math.sqrt(beta_neg));
                    } else {
                        double prec = cm.getPrecision(label, predicted);
                        double invPrec = 1.0 - prec;
                        double beta = invPrec / prec;
                        if (prec <= 0.0 || invPrec < 0.0 || Double.isInfinite(beta) || Double.isNaN(beta)) {
                            LogService.getGlobal().log("Reweighting uses invalid value:Precision is " + prec + ", inverse precision is " + invPrec + ", beta is " + beta, 5);
                        }
                        newWeight = weight * Math.sqrt(beta);
                    }
                } else {
                    newWeight = weight / lift;
                }
            }
            example.setValue(weightAttribute, newWeight);
            totalWeight += newWeight;
        }
        return totalWeight;
    }

    private static double getLiftForExample(Example example, ContingencyMatrix cm) {
        int label = (int)example.getLabel();
        int predicted = (int)example.getPredictedLabel();
        Attribute labelAttribute = example.getAttributes().getLabel();
        String predictedClass = (String)labelAttribute.getMapping().getValues().get(predicted);
        String otherClass = (String)labelAttribute.getMapping().getValues().get(1 - predicted);
        double predictedConfidence = example.getConfidence(predictedClass);
        double otherConfidence = example.getConfidence(otherClass);
        double liftPredicted = cm.getLift(label, predicted);
        double liftOther = cm.getLift(label, 1 - predicted);
        if (Double.isNaN(liftOther)) {
            liftOther = 0.0;
            predictedConfidence = 1.0;
        }
        double lift = liftPredicted * predictedConfidence + liftOther * otherConfidence;
        return lift;
    }
}

