/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import java.util.HashMap;

public class ExampleSet2DiscretizationModel
extends Operator {
    public static final String PORT_MODEL_OUTPUT = "discretization_model";
    public static final String PORT_EXAMPLESET_INPUT = "example_set";
    private OutputPort modelOuput = (OutputPort)this.getOutputPorts().createPort("discretization_model");
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example_set");

    public ExampleSet2DiscretizationModel(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        ExampleSet examples = (ExampleSet)this.exampleSetInput.getData();
        if (examples == null) {
            throw new OperatorException("no example set on input port");
        }
        Attribute nameAttribute = examples.getAttributes().getSpecial("attribute_name");
        if (nameAttribute == null) {
            throw new OperatorException("input does not contain a special 'attribute_name' attribute");
        }
        if (examples.size() != 1) {
            throw new OperatorException("input must contain exactly one example");
        }
        double[] limits = new double[examples.getAttributes().size() + 1];
        Example example = examples.getExample(0);
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            if (examples.getAttributes().getRole(attribute).isSpecial()) continue;
            limits[i] = example.getValue(attribute);
            ++i;
        }
        limits[limits.length - 1] = Double.POSITIVE_INFINITY;
        MemoryExampleTable table = new MemoryExampleTable(new Attribute[0]);
        Attribute binningAttribute = AttributeFactory.createAttribute((String)example.getNominalValue(nameAttribute), (int)4);
        table.addAttribute(binningAttribute);
        ExampleSet dummyExampleSet = table.createExampleSet();
        DiscretizationModel model = new DiscretizationModel(dummyExampleSet);
        HashMap<Attribute, double[]> rangesMap = new HashMap<Attribute, double[]>();
        rangesMap.put(binningAttribute, limits);
        model.setRanges(rangesMap, "bin", 2, -1);
        this.modelOuput.deliver((IOObject)model);
    }
}

