/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.tools.container.Tupel;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;

public class DiscretizationModel2ExampleSet
extends Operator {
    public static final String PORT_MODEL_INPUT = "discretization_model";
    public static final String PORT_EXAMPLESET_OUTPUT = "example_set";
    private InputPort modelInput = (InputPort)this.getInputPorts().createPort("discretization_model");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example_set");

    public DiscretizationModel2ExampleSet(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        DiscretizationModel model = (DiscretizationModel)this.modelInput.getDataOrNull();
        if (model == null) {
            throw new OperatorException("no data is delivered to discretization_model or it is not a DiscretizationModel");
        }
        Map allRanges = model.getRanges();
        if (allRanges.size() != 1) {
            throw new OperatorException("DiscretizationModel must contain exactly one attribute, but it contains " + allRanges.size() + " attributes.");
        }
        SortedSet ranges = (SortedSet)allRanges.values().iterator().next();
        MemoryExampleTable table = new MemoryExampleTable(new LinkedList());
        DataRowFactory rowFactory = new DataRowFactory(0, '.');
        Double[] limits = new Double[ranges.size()];
        int i = 0;
        for (Tupel bin : ranges) {
            if (i >= ranges.size() - 1) continue;
            table.addAttribute(AttributeFactory.createAttribute((String)("limit_" + (i + 1)), (int)4));
            limits[i] = (Double)bin.getFirst();
            ++i;
        }
        Attribute attributeName = AttributeFactory.createAttribute((String)"binning_attribute", (int)1);
        table.addAttribute(attributeName);
        limits[limits.length - 1] = 0.0;
        DataRow row = rowFactory.create(limits, table.getAttributes());
        table.addDataRow(row);
        ExampleSet result = table.createExampleSet();
        result.getAttributes().setSpecialAttribute(attributeName, "attribute_name");
        Example e = result.getExample(0);
        e.setValue(attributeName, ((Attribute)model.getTrainingHeader().getAttributes().iterator().next()).getName());
        this.exampleSetOutput.deliver((IOObject)result);
    }
}

