/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.Annotations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MRMRCache
extends AbstractIOObject
implements Map<String, Double> {
    private static final long serialVersionUID = -5538912232917605391L;
    protected Annotations annot;
    protected HashMap<String, Double> cache = new HashMap();
    protected int maxSize;

    public MRMRCache(int maxSize) {
        this.maxSize = maxSize;
        this.annot = new Annotations();
    }

    public void HalfCache() {
        if (this.cache == null) {
            this.cache = new HashMap();
            return;
        }
        int i = 1;
        ArrayList<String> removelist = new ArrayList<String>(this.cache.size() + 1);
        for (String key : this.cache.keySet()) {
            if (i > 0) {
                removelist.add(key);
            }
            i *= -1;
        }
        for (String key : removelist) {
            this.cache.remove(key);
        }
    }

    public Annotations getAnnotations() {
        return this.annot;
    }

    public void ClearCache() {
        this.cache.clear();
    }

    public String toString() {
        return "A cache for MRMR criteria, containing " + this.cache.size() + " entries.";
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Double>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public Double get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Double put(String key, Double value) {
        if (this.cache.size() > this.maxSize) {
            this.HalfCache();
        }
        return this.cache.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Double> m) {
        this.cache.putAll(m);
    }

    @Override
    public Double remove(Object key) {
        return this.cache.remove(key);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Collection<Double> values() {
        return this.cache.values();
    }
}

