/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.mfs.AbstractWeightingChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class WindowedWeighting
extends AbstractWeightingChain {
    public static final String PARAMETER_WINDOWS_SIZE = "window_size";
    public static final String PARAMETER_WINDOWS_OVERLAP = "window_overlap";
    protected String featureNames = null;

    public WindowedWeighting(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueString("feature_names", "The names of the used features in the current iteration."){

            public String getStringValue() {
                return WindowedWeighting.this.featureNames;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        int windowSize = this.getParameterAsInt(PARAMETER_WINDOWS_SIZE);
        int overlap = this.getParameterAsInt(PARAMETER_WINDOWS_OVERLAP);
        if (overlap >= windowSize) {
            overlap = windowSize - 1;
        }
        int stepsize = windowSize - overlap;
        this.iteration = 0;
        Attribute[] allAttributes = exampleSet.getAttributes().createRegularAttributeArray();
        Attribute label = exampleSet.getAttributes().getLabel();
        AttributeWeights weights = new AttributeWeights(exampleSet);
        if (overlap > 0) {
            for (String w : weights.getAttributeNames()) {
                weights.setWeight(w, 0.0);
            }
        }
        ExampleSet workingSet = exampleSet.getExampleTable().createExampleSet(label);
        for (int i = 0; i < allAttributes.length; i += stepsize) {
            this.inApplyLoop();
            this.featureNames = "";
            ++this.iteration;
            workingSet.getAttributes().clearRegular();
            for (int j = 0; j < windowSize && i + j < allAttributes.length; ++j) {
                workingSet.getAttributes().addRegular(allAttributes[i + j]);
            }
            this.weightingProcessExampleSetOutput.deliver((IOObject)workingSet);
            this.getSubprocess(0).execute();
            AttributeWeights windowWeights = (AttributeWeights)this.weightingProcessWeightsInput.getData();
            if (overlap == 0) {
                for (String w : windowWeights.getAttributeNames()) {
                    weights.setWeight(w, windowWeights.getWeight(w));
                }
                continue;
            }
            throw new OperatorException("Overlap >0 not yet implemented.");
        }
        this.weightsOutput.deliver((IOObject)weights);
        this.exampleSetOutput.deliver((IOObject)exampleSet);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_WINDOWS_SIZE, "Number of attributes in the sliding window", 2, Integer.MAX_VALUE, 8);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_WINDOWS_OVERLAP, "Number of overlapping attributes of two neighbouring windows. Should be smaller than window size.", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

