/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class TopK
extends Operator {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_P = "p";
    public static final String PARAMETER_INVERSE = "inverse";
    public static final String PARAMETER_ABSOLUTE = "absolute weights";
    private final InputPort weightsInput = this.getInputPorts().createPort("weights", AttributeWeights.class);
    private final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");

    public TopK(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new PassThroughRule(this.weightsInput, this.weightsOutput, false));
    }

    public void doWork() throws OperatorException {
        int i;
        AttributeWeights weights = (AttributeWeights)this.weightsInput.getData();
        String[] attributeNames = new String[weights.getAttributeNames().size()];
        attributeNames = weights.getAttributeNames().toArray(attributeNames);
        int k = this.getParameterAsInt(PARAMETER_K);
        double p = this.getParameterAsDouble(PARAMETER_P);
        boolean inverse = this.getParameterAsBoolean(PARAMETER_INVERSE);
        boolean absolute = this.getParameterAsBoolean(PARAMETER_ABSOLUTE);
        if (k < 1) {
            k = (int)(p * (double)weights.size());
        }
        weights.sortByWeight(attributeNames, inverse ? 1 : -1, absolute ? 1 : 0);
        for (i = 0; i < k && i < attributeNames.length; ++i) {
            weights.setWeight(attributeNames[i], 1.0);
        }
        for (i = k; i < attributeNames.length; ++i) {
            weights.setWeight(attributeNames[i], 0.0);
        }
        this.weightsOutput.deliver((IOObject)weights);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of features to select. If k<1 percentage p is used.", 0, Integer.MAX_VALUE, 100));
        types.add(new ParameterTypeDouble(PARAMETER_P, "The percentage of features to select. If k=0 percentage p is used.", 0.0, 1.0, 0.1));
        types.add(new ParameterTypeBoolean(PARAMETER_INVERSE, "Use the bottom-k instead of top-k.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_ABSOLUTE, "Use absolute weights.", false));
        return types;
    }
}

