/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.mfs.SAMModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class SAM
extends AbstractLearner {
    public static final String PARAMETER_USE_FEATURE_WEIGHTS = "use_features_weights";
    public static final String PARAMETER_S0 = "s0";
    private SAMModel model;

    public SAM(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.model = new SAMModel(exampleSet);
        return this.model;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_USE_FEATURE_WEIGHTS, "Use an AttributeWeights-object when calculating the distances.", true);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_S0, "Small constant to cope with variance in low expression", 0.0, Double.MAX_VALUE, 0.1);
        types.add(type);
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (capability == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return capability == OperatorCapability.WEIGHTED_EXAMPLES;
    }
}

