/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.mfs.AbstractWeightingChain;
import com.rapidminer.operator.mfs.Util;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class RecursiveFeatureElimination
extends AbstractWeightingChain {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_RATIO = "ratio";
    public static final String PARAMETER_ABSOLUTE = "use_absolute_weights";
    public static final String PARAMETER_REMOVE_FEATURES = "remove_features";

    public RecursiveFeatureElimination(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        AttributeWeights weights;
        int k = this.getParameterAsInt(PARAMETER_K);
        double ratio = this.getParameterAsDouble(PARAMETER_RATIO);
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        ExampleSet workingSet = null;
        workingSet = this.getParameterAsBoolean(PARAMETER_REMOVE_FEATURES) ? inputSet : (ExampleSet)inputSet.copy();
        boolean absolute = this.getParameterAsBoolean(PARAMETER_ABSOLUTE);
        this.iteration = 0;
        int size = workingSet.getAttributes().size();
        while (size > k) {
            this.inApplyLoop();
            ++this.iteration;
            size = (int)((double)size * ratio);
            if (size < k) {
                size = k;
            }
            this.weightingProcessExampleSetOutput.deliver((IOObject)workingSet);
            this.getSubprocess(0).execute();
            weights = (AttributeWeights)this.weightingProcessWeightsInput.getData();
            workingSet = this.selectTopK(workingSet, weights, size, absolute);
        }
        weights = new AttributeWeights(workingSet);
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_FEATURES)) {
            this.weightsOutput.deliver((IOObject)weights);
            this.exampleSetOutput.deliver((IOObject)workingSet);
        } else {
            AttributeWeights resWeights = Util.CreateZeroWeights(inputSet);
            for (String name : weights.getAttributeNames()) {
                resWeights.setWeight(name, 1.0);
            }
            this.weightsOutput.deliver((IOObject)resWeights);
            this.exampleSetOutput.deliver((IOObject)inputSet);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of features to select.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeDouble(PARAMETER_RATIO, "The percentage of features to keep in each iteration.", 0.0, 1.0, 0.5));
        types.add(new ParameterTypeBoolean(PARAMETER_ABSOLUTE, "Use the absolute attribute weights. Useful for e.g. SVM weights which can produce large negative weights for attribute with a huge influence which are anti-correlated.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_FEATURES, "Remove deselected features. Faster, but handle with care. Removes features from example set. Do not use inside cross validation and other repeated chains.", false));
        return types;
    }

    protected ExampleSet selectTopK(ExampleSet exampleset, AttributeWeights weights, int k, boolean absolute) {
        Attributes attributes = exampleset.getAttributes();
        String[] attributeNames = new String[attributes.size()];
        int index = 0;
        for (Attribute attribute : attributes) {
            attributeNames[index] = attribute.getName();
            if (Double.isNaN(weights.getWeight(attributeNames[index]))) {
                weights.setWeight(attributeNames[index], Double.NEGATIVE_INFINITY);
            }
            ++index;
        }
        weights.sortByWeight(attributeNames, -1, absolute ? 1 : 0);
        int p = attributes.size();
        Attribute att = null;
        for (int i = k; i < p; ++i) {
            att = attributes.get(attributeNames[i]);
            attributes.remove(att);
        }
        return exampleset;
    }
}

