/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.List;

public class MakePerformanceLoggable
extends Operator {
    private final InputPort perfInput = this.getInputPorts().createPort("performance", PerformanceVector.class);
    private final OutputPort perfOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private final String PARAMETER_SELECT = "select";
    private final String[] SELECT = new String[]{"main", "id", "name"};
    private final int SELECT_MAIN = 0;
    private final int SELECT_ID = 1;
    private final int SELECT_NAME = 2;
    private final String PARAMETER_ID = "id";
    private final String PARAMETER_NAME = "name";
    protected double value = 0.0;
    protected double stddev = 0.0;
    protected double number = 0.0;
    protected double variance = 0.0;

    public MakePerformanceLoggable(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new PassThroughRule(this.perfInput, this.perfOutput, false));
        this.addValue((Value)new ValueDouble("value", "Loggable performance value"){

            public double getDoubleValue() {
                return MakePerformanceLoggable.this.value;
            }
        });
        this.addValue((Value)new ValueDouble("stddev", "Standard deviation"){

            public double getDoubleValue() {
                return MakePerformanceLoggable.this.stddev;
            }
        });
        this.addValue((Value)new ValueDouble("variance", "Variance"){

            public double getDoubleValue() {
                return MakePerformanceLoggable.this.variance;
            }
        });
        this.addValue((Value)new ValueDouble("number", "Number of entries"){

            public double getDoubleValue() {
                return MakePerformanceLoggable.this.number;
            }
        });
    }

    public void doWork() throws OperatorException {
        PerformanceVector p = (PerformanceVector)this.perfInput.getData();
        int select = this.getParameterAsInt("select");
        PerformanceCriterion cr = null;
        try {
            if (select == 1) {
                cr = p.getCriterion(this.getParameterAsInt("id"));
            } else if (select == 2) {
                cr = p.getCriterion(this.getParameterAsString("name"));
            }
        }
        catch (Exception e) {
            this.logWarning("Could not find desired preformance criterion. Using main criterion.");
            cr = p.getMainCriterion();
        }
        if (select == 0 || cr == null) {
            cr = p.getMainCriterion();
        }
        this.value = cr.getAverage();
        this.stddev = cr.getStandardDeviation();
        this.variance = cr.getVariance();
        this.number = cr.getAverageCount();
        this.perfOutput.deliver((IOObject)p);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory("select", "Which criterion shall be logged?", this.SELECT, 0);
        list.add(type);
        type = new ParameterTypeInt("id", "Index of the criterion to log. Starting at 0.", 0, Integer.MAX_VALUE, 0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition(this.getParameterHandler(), "select", this.SELECT, false, new int[]{1}));
        list.add(type);
        type = new ParameterTypeString("name", "Name of the criterion to log.", "");
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition(this.getParameterHandler(), "select", this.SELECT, false, new int[]{2}));
        list.add(type);
        return list;
    }
}

