/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.Iterator;
import java.util.List;

public class FeatureQuantileFilter
extends Operator {
    public static final String PARAMETER_PERCENTAGE = "percentage";
    public static final String PARAMETER_THRESHOLD = "threshold";
    public static final String PARAMETER_FILTER_SPECIAL_FEATURES = "filter_special_features";
    private final InputPort exampleInput = this.getInputPorts().createPort("examples", ExampleSet.class);
    private final OutputPort exampleOutput = (OutputPort)this.getOutputPorts().createPort("examples");
    private ExampleSet exampleSet;
    private double percentage = 0.0;
    private double threshold = 0.0;

    public FeatureQuantileFilter(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleInput, this.exampleOutput);
    }

    public void doWork() throws OperatorException {
        Iterator i;
        this.exampleSet = (ExampleSet)this.exampleInput.getData();
        this.percentage = this.getParameterAsDouble(PARAMETER_PERCENTAGE);
        this.threshold = this.getParameterAsDouble(PARAMETER_THRESHOLD);
        int before = this.exampleSet.getAttributes().size();
        boolean filterSpecial = this.getParameterAsBoolean(PARAMETER_FILTER_SPECIAL_FEATURES);
        if (filterSpecial) {
            i = this.exampleSet.getAttributes().allAttributes();
            while (i.hasNext()) {
                Attribute att = (Attribute)i.next();
                if (this.switchOffFeature(att)) {
                    i.remove();
                }
                this.checkForStop();
            }
        } else {
            i = this.exampleSet.getAttributes().regularAttributes();
            while (i.hasNext()) {
                Attribute att = ((AttributeRole)i.next()).getAttribute();
                if (this.switchOffFeature(att)) {
                    i.remove();
                }
                this.checkForStop();
            }
        }
        int after = this.exampleSet.getAttributes().size();
        this.log("The quantile filter removed " + (before - after) + " of " + before + " attributes. " + after + " remain.");
        this.exampleOutput.deliver((IOObject)this.exampleSet);
    }

    private boolean switchOffFeature(Attribute attribute) throws OperatorException {
        if (attribute.isNumerical()) {
            double count = 0.0;
            double numberLarger = 0.0;
            double val = 0.0;
            for (Example e : this.exampleSet) {
                val = e.getValue(attribute);
                count += 1.0;
                if (!(val >= this.threshold)) continue;
                numberLarger += 1.0;
            }
            return numberLarger / count < this.percentage;
        }
        return false;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_FILTER_SPECIAL_FEATURES, "Filter also special attributes (label, id...)", false));
        types.add(new ParameterTypeDouble(PARAMETER_PERCENTAGE, "phi-Quantil", 0.0, 1.0, 0.5));
        types.add(new ParameterTypeDouble(PARAMETER_THRESHOLD, "Threshold", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

