/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;

public class ExonWelchTest
extends AbstractWeighting {
    public static final String PARAMETER_BH_KORREKTUR = "Benjamini-Hochberg-Adjustment";

    public ExonWelchTest(OperatorDescription operatordescription) {
        super(operatordescription);
    }

    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        boolean outputBH = this.getParameterAsBoolean(PARAMETER_BH_KORREKTUR);
        ArrayList<Double> labels = new ArrayList<Double>();
        AttributeWeights pValueWeights = new AttributeWeights(exampleSet);
        String[] attributeNames = new String[pValueWeights.getAttributeNames().size()];
        attributeNames = pValueWeights.getAttributeNames().toArray(attributeNames);
        int sizeAtt = exampleSet.getAttributes().size();
        int sizeEx = exampleSet.size();
        double[] labelsExamples = new double[sizeEx];
        double[] avg1 = new double[sizeAtt];
        double[] avg2 = new double[sizeAtt];
        double[] vari1 = new double[sizeAtt];
        double[] vari2 = new double[sizeAtt];
        for (Example ex : exampleSet) {
            double label1 = ex.getLabel();
            if (labels.contains(label1)) continue;
            labels.add(label1);
        }
        if (labels.size() > 2) {
            throw new UserError((Operator)this, 105, new Object[]{"Fehler"});
        }
        Iterator iterator = exampleSet.iterator();
        int i1 = 0;
        int n1 = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            double label2;
            labelsExamples[i1] = label2 = ((Example)iterator.next()).getLabel();
            if (label2 == (Double)labels.get(0)) {
                ++n1;
            } else {
                ++n2;
            }
            ++i1;
        }
        if (n1 == 0 || n2 == 0) {
            throw new UserError((Operator)this, 105, new Object[]{"Eine Klasse enth\u00c3\u00a4lt keine Beispiele!"});
        }
        for (i1 = 0; i1 < sizeAtt; ++i1) {
            avg1[i1] = 0.0;
            avg2[i1] = 0.0;
            vari1[i1] = 0.0;
            vari2[i1] = 0.0;
        }
        int j = 0;
        for (Example example : exampleSet) {
            i1 = 0;
            for (Attribute att : exampleSet.getAttributes()) {
                double value1 = example.getValue(att);
                if (labelsExamples[j] == (Double)labels.get(0)) {
                    int n = i1;
                    avg1[n] = avg1[n] + value1;
                } else {
                    int n = i1;
                    avg2[n] = avg2[n] + value1;
                }
                ++i1;
            }
            ++j;
        }
        i1 = 0;
        while (i1 < sizeAtt) {
            int n = i1;
            avg1[n] = avg1[n] / (double)n1;
            int n3 = i1++;
            avg2[n3] = avg2[n3] / (double)n2;
        }
        int j2 = 0;
        for (Example example : exampleSet) {
            i1 = 0;
            for (Attribute att : exampleSet.getAttributes()) {
                double value2 = example.getValue(att);
                if (labelsExamples[j2] == (Double)labels.get(0)) {
                    int n = i1;
                    vari1[n] = vari1[n] + (value2 - avg1[i1]) * (value2 - avg1[i1]);
                } else {
                    int n = i1;
                    vari2[n] = vari2[n] + (value2 - avg2[i1]) * (value2 - avg2[i1]);
                }
                ++i1;
            }
            ++j2;
        }
        i1 = 0;
        while (i1 < sizeAtt) {
            int n = i1;
            vari1[n] = vari1[n] / (double)(n1 - 1);
            int n4 = i1++;
            vari2[n4] = vari2[n4] / (double)(n2 - 1);
        }
        i1 = 0;
        for (Attribute att : exampleSet.getAttributes()) {
            TDistributionImpl dist;
            double dftemp = (vari1[i1] / (double)n1 + vari2[i1] / (double)n2) * (vari1[i1] / (double)n1 + vari2[i1] / (double)n2);
            double dftemp2 = vari1[i1] / (double)n1 * (vari1[i1] / (double)n1) / (double)(n1 - 1) + vari2[i1] / (double)n2 * (vari2[i1] / (double)n2) / (double)(n2 - 1);
            double t = Math.abs((avg1[i1] - avg2[i1]) / Math.sqrt(vari1[i1] / (double)n1 + vari2[i1] / (double)n2));
            double dftemp3 = Math.abs(dftemp / dftemp2);
            if (n1 != n2) {
                int df = (int)dftemp3;
                dist = new TDistributionImpl(df);
            } else {
                dist = new TDistributionImpl(dftemp3);
            }
            double cum1 = 0.0;
            double cum2 = 0.0;
            try {
                cum1 = dist.cumulativeProbability(t);
            }
            catch (MathException e) {
                e.printStackTrace();
            }
            try {
                cum2 = dist.cumulativeProbability(-t);
            }
            catch (MathException e) {
                e.printStackTrace();
            }
            double p = 1.0 - (cum1 - cum2);
            pValueWeights.setWeight(att.getName(), p);
            ++i1;
        }
        if (outputBH) {
            String[] attributeNames2 = new String[pValueWeights.getAttributeNames().size()];
            attributeNames2 = pValueWeights.getAttributeNames().toArray(attributeNames);
            int sizeWeights = pValueWeights.size();
            pValueWeights.sortByWeight(attributeNames2, 1, 0);
            for (int k = 1; k < attributeNames2.length; ++k) {
                double pValue = pValueWeights.getWeight(attributeNames2[k]);
                double newpValue = pValue * (double)sizeWeights / (double)(k + 1);
                pValueWeights.setWeight(attributeNames2[k], newpValue);
            }
        }
        pValueWeights.setSource(this.getName());
        return pValueWeights;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_BH_KORREKTUR, "calculate BH adjustment", false));
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.BINOMINAL_LABEL || capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return capability != OperatorCapability.NUMERICAL_LABEL && capability != OperatorCapability.BINOMINAL_ATTRIBUTES && capability != OperatorCapability.POLYNOMINAL_LABEL && capability != OperatorCapability.POLYNOMINAL_ATTRIBUTES;
    }
}

