/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.lasso;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.lasso.LARSModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class LARSChangeModelParameters
extends Operator {
    protected final InputPort modelInput = (InputPort)this.getInputPorts().createPort("model");
    protected final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    protected final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    public static final String PARAMETER_NUM_FEATURES = "max_features";
    public static final String PARAMETER_T = "t";

    public LARSChangeModelParameters(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        LARSModel model = (LARSModel)this.modelInput.getData();
        double threshold = this.getParameterAsDouble(PARAMETER_T);
        int numFeatures = this.getParameterAsInt(PARAMETER_NUM_FEATURES);
        model.changeModel(threshold, numFeatures);
        this.weightsOutput.deliver((IOObject)model.getWeights());
        this.modelOutput.deliver((IOObject)model);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_T, "LASSO threshold. Ignored if 0.", 0.0, Double.MAX_VALUE, 0.0));
        types.add(new ParameterTypeInt(PARAMETER_NUM_FEATURES, "Set the maximum number of features used in the beta-vector. Ignored if 0.", 0, Integer.MAX_VALUE, 0));
        return types;
    }
}

