/*
 * Decompiled with CFR 0.152.
 */
package liblinear;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import liblinear.FeatureNode;
import liblinear.Function;
import liblinear.IntArrayPointer;
import liblinear.L2LossSVMFunction;
import liblinear.L2LrFunction;
import liblinear.Model;
import liblinear.Parameter;
import liblinear.Problem;
import liblinear.SolverMCSVM_CS;
import liblinear.SolverType;
import liblinear.Tron;

public class Linear {
    static final Charset FILE_CHARSET = Charset.forName("ISO-8859-1");
    static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static boolean DEBUG_OUTPUT = false;
    static final String NL = System.getProperty("line.separator");
    private static final long DEFAULT_RANDOM_SEED = 0L;
    static Random random = new Random(0L);

    public static void crossValidation(Problem prob, Parameter param, int nr_fold, int[] target) {
        int i;
        int[] fold_start = new int[nr_fold + 1];
        int l = prob.l;
        int[] perm = new int[l];
        for (i = 0; i < l; ++i) {
            perm[i] = i;
        }
        for (i = 0; i < l; ++i) {
            int j = i + random.nextInt(l - i);
            Linear.swap(perm, i, j);
        }
        for (i = 0; i <= nr_fold; ++i) {
            fold_start[i] = i * l / nr_fold;
        }
        for (i = 0; i < nr_fold; ++i) {
            int j;
            int begin = fold_start[i];
            int end = fold_start[i + 1];
            Problem subprob = new Problem();
            subprob.bias = prob.bias;
            subprob.n = prob.n;
            subprob.l = l - (end - begin);
            subprob.x = new FeatureNode[l][];
            subprob.y = new int[subprob.l];
            int k = 0;
            for (j = 0; j < begin; ++j) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
            }
            for (j = end; j < l; ++j) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
            }
            Model submodel = Linear.train(subprob, param);
            for (j = begin; j < end; ++j) {
                target[perm[j]] = Linear.predict(submodel, prob.x[perm[j]]);
            }
        }
    }

    private static GroupClassesReturn groupClasses(Problem prob, int[] perm) {
        int i;
        int l = prob.l;
        int max_nr_class = 16;
        int nr_class = 0;
        int[] label = new int[max_nr_class];
        int[] count = new int[max_nr_class];
        int[] data_label = new int[l];
        for (i = 0; i < l; ++i) {
            int j;
            int this_label = prob.y[i];
            for (j = 0; j < nr_class; ++j) {
                if (this_label != label[j]) continue;
                int n = j;
                count[n] = count[n] + 1;
                break;
            }
            data_label[i] = j;
            if (j != nr_class) continue;
            if (nr_class == max_nr_class) {
                label = Linear.copyOf(label, max_nr_class *= 2);
                count = Linear.copyOf(count, max_nr_class);
            }
            label[nr_class] = this_label;
            count[nr_class] = 1;
            ++nr_class;
        }
        int[] start = new int[nr_class];
        start[0] = 0;
        for (i = 1; i < nr_class; ++i) {
            start[i] = start[i - 1] + count[i - 1];
        }
        for (i = 0; i < l; ++i) {
            perm[start[data_label[i]]] = i;
            int n = data_label[i];
            start[n] = start[n] + 1;
        }
        start[0] = 0;
        for (i = 1; i < nr_class; ++i) {
            start[i] = start[i - 1] + count[i - 1];
        }
        return new GroupClassesReturn(nr_class, label, start, count);
    }

    static void info(String message) {
        if (!DEBUG_OUTPUT) {
            return;
        }
        System.out.print(message);
    }

    static void info(String format, Object ... args) {
        if (!DEBUG_OUTPUT) {
            return;
        }
        System.out.printf(format, args);
    }

    static void infoFlush() {
        if (!DEBUG_OUTPUT) {
            return;
        }
        System.out.flush();
    }

    static double atof(String s) {
        double d = Double.parseDouble(s);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("NaN or Infinity in input: " + s);
        }
        return d;
    }

    static int atoi(String s) {
        if (s == null || s.length() < 1) {
            throw new IllegalArgumentException("Can't convert empty string to integer");
        }
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        return Integer.parseInt(s);
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model loadModel(BufferedReader inputReader) throws IOException {
        Model model = new Model();
        model.label = null;
        Pattern whitespace = Pattern.compile("\\s+");
        try {
            String line = null;
            while ((line = inputReader.readLine()) != null) {
                String[] split = whitespace.split(line);
                if (split[0].equals("solver_type")) {
                    SolverType solver = SolverType.valueOf(split[1]);
                    if (solver == null) {
                        throw new RuntimeException("unknown solver type");
                    }
                    model.solverType = solver;
                    continue;
                }
                if (split[0].equals("nr_class")) {
                    model.nr_class = Linear.atoi(split[1]);
                    Integer.parseInt(split[1]);
                    continue;
                }
                if (split[0].equals("nr_feature")) {
                    model.nr_feature = Linear.atoi(split[1]);
                    continue;
                }
                if (split[0].equals("bias")) {
                    model.bias = Linear.atof(split[1]);
                    continue;
                }
                if (split[0].equals("w")) break;
                if (split[0].equals("label")) {
                    model.label = new int[model.nr_class];
                    for (int i = 0; i < model.nr_class; ++i) {
                        model.label[i] = Linear.atoi(split[i + 1]);
                    }
                    continue;
                }
                throw new RuntimeException("unknown text in model file: [" + line + "]");
            }
            int n = model.nr_feature;
            if (model.bias >= 0.0) {
                ++n;
            }
            int nr_w = model.nr_class;
            if (model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS) {
                nr_w = 1;
            }
            model.w = new double[n * nr_w];
            int[] buffer = new int[128];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < nr_w; ++j) {
                    int b = 0;
                    while (true) {
                        int ch;
                        if ((ch = inputReader.read()) == -1) {
                            throw new EOFException("unexpected EOF");
                        }
                        if (ch == 32) break;
                        buffer[b++] = ch;
                    }
                    model.w[i * nr_w + j] = Linear.atof(new String(buffer, 0, b));
                }
            }
        }
        finally {
            Linear.closeQuietly(inputReader);
        }
        return model;
    }

    public static Model loadModel(File modelFile) throws IOException {
        BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(modelFile), FILE_CHARSET));
        return Linear.loadModel(inputReader);
    }

    static void closeQuietly(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int predict(Model model, FeatureNode[] x) {
        double[] dec_values = new double[model.nr_class];
        return Linear.predictValues(model, x, dec_values);
    }

    public static int predictProbability(Model model, FeatureNode[] x, double[] prob_estimates) {
        if (model.solverType == SolverType.L2_LR) {
            int nr_class = model.nr_class;
            int nr_w = nr_class == 2 ? 1 : nr_class;
            int label = Linear.predictValues(model, x, prob_estimates);
            for (int i = 0; i < nr_w; ++i) {
                prob_estimates[i] = 1.0 / (1.0 + Math.exp(-prob_estimates[i]));
            }
            if (nr_class == 2) {
                prob_estimates[1] = 1.0 - prob_estimates[0];
            } else {
                int i;
                double sum = 0.0;
                for (i = 0; i < nr_class; ++i) {
                    sum += prob_estimates[i];
                }
                for (i = 0; i < nr_class; ++i) {
                    prob_estimates[i] = prob_estimates[i] / sum;
                }
            }
            return label;
        }
        return 0;
    }

    public static int predictValues(Model model, FeatureNode[] x, double[] dec_values) {
        int n = model.bias >= 0.0 ? model.nr_feature + 1 : model.nr_feature;
        double[] w = model.w;
        int nr_w = model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS ? 1 : model.nr_class;
        for (int i = 0; i < nr_w; ++i) {
            dec_values[i] = 0.0;
        }
        for (FeatureNode lx : x) {
            int idx = lx.index;
            if (idx > n) continue;
            for (int i = 0; i < nr_w; ++i) {
                int n2 = i;
                dec_values[n2] = dec_values[n2] + w[(idx - 1) * nr_w + i] * lx.value;
            }
        }
        if (model.nr_class == 2) {
            return dec_values[0] > 0.0 ? model.label[0] : model.label[1];
        }
        int dec_max_idx = 0;
        for (int i = 1; i < model.nr_class; ++i) {
            if (!(dec_values[i] > dec_values[dec_max_idx])) continue;
            dec_max_idx = i;
        }
        return model.label[dec_max_idx];
    }

    static void printf(Formatter formatter, String format, Object ... args) throws IOException {
        formatter.format(format, args);
        IOException ioException = formatter.ioException();
        if (ioException != null) {
            throw ioException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModel(Writer modelOutput, Model model) throws IOException {
        int nr_feature;
        int n = nr_feature = model.nr_feature;
        if (model.bias >= 0.0) {
            ++n;
        }
        int nr_w = model.nr_class;
        if (model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS) {
            nr_w = 1;
        }
        Formatter formatter = new Formatter(modelOutput, DEFAULT_LOCALE);
        try {
            int i;
            Linear.printf(formatter, "solver_type %s\n", model.solverType.name());
            Linear.printf(formatter, "nr_class %d\n", model.nr_class);
            Linear.printf(formatter, "label", new Object[0]);
            for (i = 0; i < model.nr_class; ++i) {
                Linear.printf(formatter, " %d", model.label[i]);
            }
            Linear.printf(formatter, "\n", new Object[0]);
            Linear.printf(formatter, "nr_feature %d\n", nr_feature);
            Linear.printf(formatter, "bias %.16g\n", model.bias);
            Linear.printf(formatter, "w\n", new Object[0]);
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < nr_w; ++j) {
                    Linear.printf(formatter, "%.16g ", model.w[i * nr_w + j]);
                }
                Linear.printf(formatter, "\n", new Object[0]);
            }
            formatter.flush();
            IOException ioException = formatter.ioException();
            if (ioException != null) {
                throw ioException;
            }
        }
        finally {
            formatter.close();
        }
    }

    public static void saveModel(File modelFile, Model model) throws IOException {
        BufferedWriter modelOutput = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(modelFile), FILE_CHARSET));
        Linear.saveModel(modelOutput, model);
    }

    private static void solve_linear_c_svc(Problem prob, double[] w, double eps, double Cp, double Cn, SolverType solver_type) {
        int i;
        int l = prob.l;
        int n = prob.n;
        int iter = 0;
        double[] QD = new double[l];
        int max_iter = 20000;
        int[] index = new int[l];
        double[] alpha = new double[l];
        byte[] y = new byte[l];
        int active_size = l;
        double PGmax_old = Double.POSITIVE_INFINITY;
        double PGmin_old = Double.NEGATIVE_INFINITY;
        double diag_p = 0.5 / Cp;
        double diag_n = 0.5 / Cn;
        double upper_bound_p = Double.POSITIVE_INFINITY;
        double upper_bound_n = Double.POSITIVE_INFINITY;
        if (solver_type == SolverType.L1LOSS_SVM_DUAL) {
            diag_p = 0.0;
            diag_n = 0.0;
            upper_bound_p = Cp;
            upper_bound_n = Cn;
        }
        for (i = 0; i < n; ++i) {
            w[i] = 0.0;
        }
        for (i = 0; i < l; ++i) {
            alpha[i] = 0.0;
            if (prob.y[i] > 0) {
                y[i] = 1;
                QD[i] = diag_p;
            } else {
                y[i] = -1;
                QD[i] = diag_n;
            }
            for (FeatureNode xi : prob.x[i]) {
                int n2 = i;
                QD[n2] = QD[n2] + xi.value * xi.value;
            }
            index[i] = i;
        }
        while (iter < max_iter) {
            double PGmax_new = Double.NEGATIVE_INFINITY;
            double PGmin_new = Double.POSITIVE_INFINITY;
            for (i = 0; i < active_size; ++i) {
                int j = i + random.nextInt(active_size - i);
                Linear.swap(index, i, j);
            }
            for (int s = 0; s < active_size; ++s) {
                double C;
                i = index[s];
                double G = 0.0;
                byte yi = y[i];
                for (FeatureNode xi : prob.x[i]) {
                    G += w[xi.index - 1] * xi.value;
                }
                G = G * (double)yi - 1.0;
                if (yi == 1) {
                    C = upper_bound_p;
                    G += alpha[i] * diag_p;
                } else {
                    C = upper_bound_n;
                    G += alpha[i] * diag_n;
                }
                double PG = 0.0;
                if (alpha[i] == 0.0) {
                    if (G > PGmax_old) {
                        Linear.swap(index, s, --active_size);
                        --s;
                        continue;
                    }
                    if (G < 0.0) {
                        PG = G;
                    }
                } else if (alpha[i] == C) {
                    if (G < PGmin_old) {
                        Linear.swap(index, s, --active_size);
                        --s;
                        continue;
                    }
                    if (G > 0.0) {
                        PG = G;
                    }
                } else {
                    PG = G;
                }
                PGmax_new = Math.max(PGmax_new, PG);
                PGmin_new = Math.min(PGmin_new, PG);
                if (!(Math.abs(PG) > 1.0E-12)) continue;
                double alpha_old = alpha[i];
                alpha[i] = Math.min(Math.max(alpha[i] - G / QD[i], 0.0), C);
                double d = (alpha[i] - alpha_old) * (double)yi;
                for (FeatureNode xi : prob.x[i]) {
                    int n3 = xi.index - 1;
                    w[n3] = w[n3] + d * xi.value;
                }
            }
            if (++iter % 10 == 0) {
                Linear.info(".");
                Linear.infoFlush();
            }
            if (PGmax_new - PGmin_new <= eps) {
                if (active_size == l) break;
                active_size = l;
                Linear.info("*");
                Linear.infoFlush();
                PGmax_old = Double.POSITIVE_INFINITY;
                PGmin_old = Double.NEGATIVE_INFINITY;
                continue;
            }
            PGmax_old = PGmax_new;
            PGmin_old = PGmin_new;
            if (PGmax_old <= 0.0) {
                PGmax_old = Double.POSITIVE_INFINITY;
            }
            if (!(PGmin_old >= 0.0)) continue;
            PGmin_old = Double.NEGATIVE_INFINITY;
        }
        Linear.info(NL + "optimization finished, #iter = %d" + NL, iter);
        if (iter >= max_iter) {
            Linear.info("Warning: reaching max number of iterations\n");
        }
        double v = 0.0;
        int nSV = 0;
        for (i = 0; i < n; ++i) {
            v += w[i] * w[i];
        }
        for (i = 0; i < l; ++i) {
            v = y[i] == 1 ? (v += alpha[i] * (alpha[i] * diag_p - 2.0)) : (v += alpha[i] * (alpha[i] * diag_n - 2.0));
            if (!(alpha[i] > 0.0)) continue;
            ++nSV;
        }
        Linear.info("Objective value = %f" + NL, v / 2.0);
        Linear.info("nSV = %d" + NL, nSV);
    }

    static void swap(double[] array, int idxA, int idxB) {
        double temp = array[idxA];
        array[idxA] = array[idxB];
        array[idxB] = temp;
    }

    static void swap(int[] array, int idxA, int idxB) {
        int temp = array[idxA];
        array[idxA] = array[idxB];
        array[idxB] = temp;
    }

    static void swap(IntArrayPointer array, int idxA, int idxB) {
        int temp = array.get(idxA);
        array.set(idxA, array.get(idxB));
        array.set(idxB, temp);
    }

    public static Model train(Problem prob, Parameter param) {
        int k;
        int j;
        int i;
        if (prob == null) {
            throw new IllegalArgumentException("problem must not be null");
        }
        if (param == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        int l = prob.l;
        int n = prob.n;
        Model model = new Model();
        model.nr_feature = prob.bias >= 0.0 ? n - 1 : n;
        model.solverType = param.solverType;
        model.bias = prob.bias;
        int[] perm = new int[l];
        GroupClassesReturn rv = Linear.groupClasses(prob, perm);
        int nr_class = rv.nr_class;
        int[] label = rv.label;
        int[] start = rv.start;
        int[] count = rv.count;
        model.nr_class = nr_class;
        model.label = new int[nr_class];
        for (i = 0; i < nr_class; ++i) {
            model.label[i] = label[i];
        }
        double[] weighted_C = new double[nr_class];
        for (i = 0; i < nr_class; ++i) {
            weighted_C[i] = param.C;
        }
        for (i = 0; i < param.getNumWeights(); ++i) {
            for (j = 0; j < nr_class && param.weightLabel[i] != label[j]; ++j) {
            }
            if (j == nr_class) {
                throw new IllegalArgumentException("class label " + param.weightLabel[i] + " specified in weight is not found");
            }
            int n2 = j;
            weighted_C[n2] = weighted_C[n2] * param.weight[i];
        }
        FeatureNode[][] x = new FeatureNode[l][];
        for (i = 0; i < l; ++i) {
            x[i] = prob.x[perm[i]];
        }
        Problem sub_prob = new Problem();
        sub_prob.l = l;
        sub_prob.n = n;
        sub_prob.x = new FeatureNode[sub_prob.l][];
        sub_prob.y = new int[sub_prob.l];
        for (k = 0; k < sub_prob.l; ++k) {
            sub_prob.x[k] = x[k];
        }
        if (param.solverType == SolverType.MCSVM_CS) {
            model.w = new double[n * nr_class];
            for (i = 0; i < nr_class; ++i) {
                for (j = start[i]; j < start[i] + count[i]; ++j) {
                    sub_prob.y[j] = i;
                }
            }
            SolverMCSVM_CS solver = new SolverMCSVM_CS(sub_prob, nr_class, weighted_C, param.eps);
            solver.solve(model.w);
        } else if (nr_class == 2) {
            model.w = new double[n];
            int e0 = start[0] + count[0];
            for (k = 0; k < e0; ++k) {
                sub_prob.y[k] = 1;
            }
            while (k < sub_prob.l) {
                sub_prob.y[k] = -1;
                ++k;
            }
            Linear.train_one(sub_prob, param, model.w, weighted_C[0], weighted_C[1]);
        } else {
            model.w = new double[n * nr_class];
            double[] w = new double[n];
            for (i = 0; i < nr_class; ++i) {
                int si = start[i];
                int ei = si + count[i];
                for (k = 0; k < si; ++k) {
                    sub_prob.y[k] = -1;
                }
                while (k < ei) {
                    sub_prob.y[k] = 1;
                    ++k;
                }
                while (k < sub_prob.l) {
                    sub_prob.y[k] = -1;
                    ++k;
                }
                Linear.train_one(sub_prob, param, w, weighted_C[i], param.C);
                for (j = 0; j < n; ++j) {
                    model.w[j * nr_class + i] = w[j];
                }
            }
        }
        return model;
    }

    private static void train_one(Problem prob, Parameter param, double[] w, double Cp, double Cn) {
        double eps = param.eps;
        int pos = 0;
        for (int i = 0; i < prob.l; ++i) {
            if (prob.y[i] != 1) continue;
            ++pos;
        }
        int neg = prob.l - pos;
        Function fun_obj = null;
        switch (param.solverType) {
            case L2_LR: {
                fun_obj = new L2LrFunction(prob, Cp, Cn);
                Tron tron_obj = new Tron(fun_obj, eps * (double)Math.min(pos, neg) / (double)prob.l);
                tron_obj.tron(w);
                break;
            }
            case L2LOSS_SVM: {
                fun_obj = new L2LossSVMFunction(prob, Cp, Cn);
                Tron tron_obj = new Tron(fun_obj, eps * (double)Math.min(pos, neg) / (double)prob.l);
                tron_obj.tron(w);
                break;
            }
            case L2LOSS_SVM_DUAL: {
                Linear.solve_linear_c_svc(prob, w, eps, Cp, Cn, SolverType.L2LOSS_SVM_DUAL);
                break;
            }
            case L1LOSS_SVM_DUAL: {
                Linear.solve_linear_c_svc(prob, w, eps, Cp, Cn, SolverType.L1LOSS_SVM_DUAL);
                break;
            }
            default: {
                throw new IllegalStateException("unknown solver type: " + (Object)((Object)param.solverType));
            }
        }
    }

    public static void disableDebugOutput() {
        DEBUG_OUTPUT = false;
    }

    public static void enableDebugOutput() {
        DEBUG_OUTPUT = true;
    }

    public static void resetRandom() {
        random = new Random(0L);
    }

    private static class GroupClassesReturn {
        final int[] count;
        final int[] label;
        final int nr_class;
        final int[] start;

        GroupClassesReturn(int nr_class, int[] label, int[] start, int[] count) {
            this.nr_class = nr_class;
            this.label = label;
            this.start = start;
            this.count = count;
        }
    }
}

