/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.madm.paren.operator.learner.functions.neuralnet;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.RandomGenerator;
import de.dfki.madm.paren.operator.learner.functions.neuralnet.AutoMLPImprovedNeuralNetModel;
import java.util.Iterator;
import java.util.List;

class AutoMlpThreaded
extends Thread {
    AutoMLPImprovedNeuralNetModel[] model;
    int nensembles = 1;
    ExampleSet exampleSet;
    List<String[]>[] hiddenLayers;
    int maxCycles;
    double maxError;
    double[] learningRate;
    double momentum;
    boolean decay;
    boolean shuffle;
    boolean normalize;
    RandomGenerator randomGenerator;
    boolean[] isOldModels;
    AutoMLPImprovedNeuralNetModel[] oldModels;

    AutoMlpThreaded(ExampleSet example, int nn, List<String[]>[] hidden_layers, int max_cycles, double max_Error, double[] learning_Rate, double moment, boolean is_decay, boolean is_shuffle, boolean is_normalize, RandomGenerator random_Generator, boolean[] is_old_models, AutoMLPImprovedNeuralNetModel[] old_models) {
        this.exampleSet = example;
        this.nensembles = nn;
        this.hiddenLayers = hidden_layers;
        this.maxCycles = max_cycles;
        this.maxError = max_Error;
        this.learningRate = learning_Rate;
        this.momentum = moment;
        this.decay = is_decay;
        this.shuffle = is_shuffle;
        this.normalize = is_normalize;
        this.randomGenerator = random_Generator;
        this.isOldModels = is_old_models;
        this.oldModels = old_models;
        this.model = new AutoMLPImprovedNeuralNetModel[this.nensembles];
        for (int i = 0; i < this.nensembles; ++i) {
            this.model[i] = new AutoMLPImprovedNeuralNetModel(this.exampleSet);
        }
    }

    @Override
    public void run() {
        try {
            for (int i = 0; i < this.nensembles; ++i) {
                Iterator<String[]> it = this.hiddenLayers[i].iterator();
                int layerSize = 0;
                if (it.hasNext()) {
                    String[] nameSizePair = it.next();
                    layerSize = Integer.valueOf(nameSizePair[1]);
                }
                this.model[i].train(this.exampleSet, this.hiddenLayers[i], this.maxCycles, this.maxError, this.learningRate[i], this.momentum, this.decay, this.shuffle, this.normalize, this.randomGenerator, this.isOldModels[i], this.oldModels[i]);
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void StartTraining() {
        this.start();
    }

    void CrossValidate(ExampleSet splittedES) {
        for (int i = 0; i < this.nensembles; ++i) {
            int maxSize = splittedES.size();
            double error = 0.0;
            for (int index = 0; index < maxSize; ++index) {
                error += this.model[i].calculateError(splittedES.getExample(index));
            }
            this.model[i].error = error;
        }
    }

    public double[] GetModelsErrors() {
        double[] errors = new double[this.nensembles];
        for (int i = 0; i < this.nensembles; ++i) {
            errors[i] = this.model[i].getError();
        }
        return errors;
    }

    public AutoMLPImprovedNeuralNetModel GetModel(int index) {
        return this.model[index];
    }
}

