/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.madm.paren.operator.learner.functions.neuralnet;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.neuralnet.InnerNode;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import de.dfki.madm.paren.operator.learner.functions.neuralnet.AutoMLPImprovedNeuralNetModel;
import de.dfki.madm.paren.operator.learner.functions.neuralnet.AutoMlpThreaded;
import java.util.LinkedList;
import java.util.List;

public class AutoMLPImprovedNeuralNetLearner
extends AbstractLearner {
    public static final String PARAMETER_TRAINING_CYCLES = "training_cycles";
    private static final String PARAMETER_MAX_GENERATIONS = "number_of_generations";
    private static final String PARAMETER_NUMBER_ENSEMBLES = "number_of_esemble_mlps";
    RandomGenerator randomGenerator;
    protected PerformanceVector performance;

    public AutoMLPImprovedNeuralNetLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        int maxCycles = this.getParameterAsInt(PARAMETER_TRAINING_CYCLES);
        int max_generations = this.getParameterAsInt(PARAMETER_MAX_GENERATIONS);
        int nensemble = this.getParameterAsInt(PARAMETER_NUMBER_ENSEMBLES);
        double eta_init = 0.5;
        int min_hidden = 5;
        int max_hidden = 300;
        double eta_varlog = 1.5;
        double hidden_varlog = 1.8;
        int generations = 0;
        double maxError = 0.0;
        double momentum = 0.5;
        boolean decay = false;
        boolean shuffle = true;
        boolean normalize = true;
        int hidden_lo = 20;
        int hidden_hi = 80;
        double cv_split = 0.8;
        this.randomGenerator = RandomGenerator.getRandomGenerator(this);
        AutoMLPImprovedNeuralNetModel[] old_models = new AutoMLPImprovedNeuralNetModel[nensemble];
        boolean[] is_old_models = new boolean[nensemble];
        double[] learningRate = new double[nensemble];
        LinkedList[] hiddenLayers = new LinkedList[nensemble];
        for (int i = 0; i < nensemble; ++i) {
            hiddenLayers[i] = new LinkedList();
            is_old_models[i] = false;
            do {
                learningRate[i] = this.rlognormal(eta_init, eta_varlog);
            } while (learningRate[i] < 0.0 || learningRate[i] >= 1.0);
            int nn = this.logspace(i, nensemble, hidden_lo, hidden_hi);
            if (nn >= max_hidden) continue;
            hiddenLayers[i].add(new String[]{"Hidden", Integer.toString(nn)});
        }
        int number_of_classes = exampleSet.getAttributes().getLabel().getMapping().size();
        SplittedExampleSet splittedES = new SplittedExampleSet(exampleSet, cv_split, 1, false, 1992);
        do {
            int i;
            splittedES.selectSingleSubset(0);
            AutoMlpThreaded autoMlpThread = new AutoMlpThreaded(splittedES, nensemble, hiddenLayers, maxCycles, maxError, learningRate, momentum, decay, shuffle, normalize, this.randomGenerator, is_old_models, old_models);
            autoMlpThread.StartTraining();
            while (autoMlpThread.isAlive()) {
            }
            for (i = 0; i < nensemble; ++i) {
                old_models[i] = autoMlpThread.GetModel(i);
                is_old_models[i] = true;
            }
            splittedES.selectSingleSubset(1);
            autoMlpThread.CrossValidate(splittedES);
            for (i = 0; i < nensemble; ++i) {
                old_models[i].error = this.calculateError(splittedES, old_models[i]);
            }
            double[] errors = autoMlpThread.GetModelsErrors();
            this.quicksort(old_models, learningRate, 0, old_models.length - 1);
            for (i = 0; i < nensemble / 2; ++i) {
                hiddenLayers[i].clear();
                int current_size = 0;
                for (int k = 0; k < old_models[i].innerNodes.length; ++k) {
                    InnerNode old_innerNode = old_models[i].innerNodes[k];
                    int old_layerIndex = old_innerNode.getLayerIndex();
                    if (old_layerIndex == -2) continue;
                    ++current_size;
                }
                hiddenLayers[i].add(new String[]{"Hidden", Integer.toString(current_size)});
            }
            i = nensemble / 2;
            int j = 0;
            while (i < nensemble) {
                do {
                    learningRate[i] = this.rlognormal(eta_init, eta_varlog);
                } while (learningRate[i] < 0.0 || learningRate[i] >= 1.0);
                old_models[i] = old_models[j];
                int current_size = 0;
                for (int k = 0; k < old_models[j].innerNodes.length; ++k) {
                    InnerNode old_innerNode = old_models[j].innerNodes[k];
                    int old_layerIndex = old_innerNode.getLayerIndex();
                    if (old_layerIndex == -2) continue;
                    ++current_size;
                }
                int value = 0;
                while ((value = (int)this.rlognormal(current_size, hidden_varlog)) < 0) {
                }
                if (value > 0) {
                    int nn = 0;
                    while ((nn = Math.min(Math.max(min_hidden, value), max_hidden)) > max_hidden) {
                    }
                    if (nn < max_hidden) {
                        hiddenLayers[i].clear();
                        hiddenLayers[i].add(new String[]{"Hidden", Integer.toString(nn)});
                    }
                }
                ++i;
                ++j;
            }
        } while (++generations < max_generations);
        AutoMLPImprovedNeuralNetModel model = old_models[0];
        return model;
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return AutoMLPImprovedNeuralNetModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.POLYNOMINAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.NUMERICAL_LABEL) {
            return true;
        }
        return lc == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_TRAINING_CYCLES, "The number of maximum training cycles used for the neural network training.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(true);
        types.add(type);
        ParameterTypeInt type2 = new ParameterTypeInt(PARAMETER_MAX_GENERATIONS, "The number of generations for AutoMLP training.", 1, Integer.MAX_VALUE, 10);
        type2.setExpert(true);
        types.add(type2);
        ParameterTypeInt type3 = new ParameterTypeInt(PARAMETER_NUMBER_ENSEMBLES, "The number of MLPs per ensemble.", 1, Integer.MAX_VALUE, 4);
        type3.setExpert(true);
        types.add(type3);
        return types;
    }

    private double rlognormal(double etaInit, double r) {
        if (r > 1.0) {
            double n;
            double result;
            while (Double.isNaN(result = Math.exp(n = this.rnormal(Math.log(etaInit), Math.log(r))))) {
            }
            return result;
        }
        return -1.0;
    }

    private double rnormal(double d, double e) {
        return this.rnormal() * e + d;
    }

    private double rnormal() {
        double y;
        double x;
        double s;
        while ((s = (x = 2.0 * this.randomGenerator.nextGaussian() - 1.0) * x + (y = 2.0 * this.randomGenerator.nextGaussian() - 1.0) * y) > 1.0) {
        }
        double retValue = 0.0;
        while (Double.isNaN(retValue = x * Math.sqrt(-Math.log(s) / s))) {
        }
        return retValue;
    }

    private int logspace(int i, int n, float lo, float hi) {
        Double d;
        while ((d = Double.valueOf(Math.exp((double)((float)i / (float)(n - 1)) * (Math.log(hi) - Math.log(lo)) + Math.log(lo)))).isNaN()) {
        }
        return d.intValue();
    }

    private void quicksort(AutoMLPImprovedNeuralNetModel[] old_nn, double[] lR, int low, int high) {
        int i = low;
        int j = high;
        double pivot = old_nn[low + high >>> 1].getError();
        while (i <= j) {
            while (i < high && old_nn[i].getError() < pivot) {
                ++i;
            }
            while (j > low && old_nn[j].getError() > pivot) {
                --j;
            }
            if (i > j) continue;
            this.Swap(old_nn, lR, i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.quicksort(old_nn, lR, low, j);
        }
        if (i < high) {
            this.quicksort(old_nn, lR, i, high);
        }
    }

    private void Swap(AutoMLPImprovedNeuralNetModel[] models, double[] lR, int index_1, int index_2) {
        AutoMLPImprovedNeuralNetModel temp = models[index_1];
        double l_temp = lR[index_1];
        models[index_1] = models[index_2];
        models[index_2] = temp;
        lR[index_1] = lR[index_2];
        lR[index_2] = l_temp;
    }

    protected float calculateError(ExampleSet exampleSet, AutoMLPImprovedNeuralNetModel model) {
        Attribute predictedLabel = exampleSet.getAttributes().getLabel();
        long count = 0L;
        long misclassified = 0L;
        for (Example example : exampleSet) {
            model.resetNetwork();
            ++count;
            if (!predictedLabel.isNominal()) continue;
            int numberOfClasses = model.getNumberOfClasses(predictedLabel);
            double[] classProbabilities = new double[numberOfClasses];
            for (int c = 0; c < numberOfClasses; ++c) {
                classProbabilities[c] = model.outputNodes[c].calculateValue(true, example);
            }
            double total = 0.0;
            for (int c = 0; c < numberOfClasses; ++c) {
                total += classProbabilities[c];
            }
            double maxConfidence = Double.NEGATIVE_INFINITY;
            int maxIndex = 0;
            for (int c = 0; c < numberOfClasses; ++c) {
                int n = c;
                classProbabilities[n] = classProbabilities[n] / total;
                if (!(classProbabilities[c] > maxConfidence)) continue;
                maxIndex = c;
                maxConfidence = classProbabilities[c];
            }
            if ((double)maxIndex == example.getLabel()) continue;
            ++misclassified;
        }
        return (float)misclassified / (float)count;
    }
}

