/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.xml;

import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHTMLEntityResolver
implements EntityResolver {
    private static final List<Pair<Pattern, String>> systemIdToResources = new LinkedList<Pair<Pattern, String>>();
    private static final Map<String, String> publicIdToResources = new HashMap<String, String>();
    private EntityResolver fallback;

    public XHTMLEntityResolver(EntityResolver fallback) {
        this.fallback = fallback;
    }

    public XHTMLEntityResolver() {
        this.fallback = null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null) {
            for (Pair<Pattern, String> pair : systemIdToResources) {
                URL resource;
                Matcher matcher = pair.getFirst().matcher(systemId);
                if (!matcher.matches() || (resource = this.getClass().getResource(matcher.replaceAll(pair.getSecond()))) == null) continue;
                InputSource inputSource = new InputSource(resource.toExternalForm());
                inputSource.setPublicId(publicId);
                return inputSource;
            }
        } else {
            URL resource;
            String resourceLocation = publicIdToResources.get(publicId);
            if (resourceLocation != null && (resource = this.getClass().getResource(resourceLocation)) != null) {
                InputSource inputSource = new InputSource(resource.toExternalForm());
                inputSource.setPublicId(publicId);
                return inputSource;
            }
        }
        if (this.fallback != null) {
            return this.fallback.resolveEntity(publicId, systemId);
        }
        return null;
    }

    static {
        systemIdToResources.add(new Pair<Pattern, String>(Pattern.compile("http://www\\.w3\\.org/TR/html4/(.*)"), "/com/rapidminer/resources/dtds/$1"));
        systemIdToResources.add(new Pair<Pattern, String>(Pattern.compile("http://www\\.w3\\.org/TR/xhtml1/DTD/(.*)"), "/com/rapidminer/resources/dtds/$1"));
        systemIdToResources.add(new Pair<Pattern, String>(Pattern.compile("http://www\\.w3\\.org/TR/xhtml11/DTD/(.*)"), "/com/rapidminer/resources/dtds/$1"));
        publicIdToResources.put("-//W3C//DTD HTML 4.01//EN", "/com/rapidminer/resources/dtds/strict.dtd");
        publicIdToResources.put("-//W3C//DTD HTML 4.01 Transitional//EN", "/com/rapidminer/resources/dtds/loose.dtd");
        publicIdToResources.put("-//W3C//DTD HTML 4.01 Frameset//EN", "/com/rapidminer/resources/dtds/frameset.dtd");
        publicIdToResources.put("-//W3C//DTD XHTML 1.0 Strict//EN", "/com/rapidminer/resources/dtds/xhtml1-strict.dtd");
        publicIdToResources.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "/com/rapidminer/resources/dtds/xhtml1-transitional.dtd");
        publicIdToResources.put("-//W3C//DTD XHTML 1.0 Frameset//EN", "/com/rapidminer/resources/dtds/xhtml1-frameset.dtd");
        publicIdToResources.put("-//W3C//DTD XHTML 1.1//EN", "/com/rapidminer/resources/dtds/xhtml11.dtd");
    }
}

