/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.usagestats;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.viewer.DataTableViewerTable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;

public class UsageStatsTransmissionDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private static final long MIN_FIRE_INTERVAL = 600000L;
    public static final int ASK = 0;
    public static final int ALWAYS = 1;
    public static final int NEVER = 2;
    private static final int YES = 0;
    private static final int NO = 1;
    private int answer;
    public static final Action SHOW_STATISTICS_ACTION = new ResourceAction("show_usage_statistics", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            RapidMinerGUI.getMainFrame().getResultDisplay().addDataTable(UsageStatistics.getInstance().getAsDataTable(UsageStatistics.StatisticsScope.ALL_TIME));
        }
    };

    private UsageStatsTransmissionDialog() {
        super("transmit_usage_statistics", true, new Object[0]);
        JButton neverButton = new JButton(new ResourceAction("never", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UsageStatsTransmissionDialog.this.dispose();
                ParameterService.writePropertyIntoMainUserConfigFile("rapidminer.gui.transfer_usagestats", "never");
                UsageStatsTransmissionDialog.this.answer = 1;
            }
        });
        JButton alwaysButton = new JButton(new ResourceAction("always", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UsageStatsTransmissionDialog.this.answer = 0;
                ParameterService.writePropertyIntoMainUserConfigFile("rapidminer.gui.transfer_usagestats", "always");
                UsageStatsTransmissionDialog.this.dispose();
            }
        });
        DataTableViewerTable table = new DataTableViewerTable(UsageStatistics.getInstance().getAsDataTable(UsageStatistics.StatisticsScope.CURRENT), true, true, true);
        table.setFocusable(false);
        table.setBorder(null);
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(table);
        tablePane.setBorder(UsageStatsTransmissionDialog.createBorder());
        this.layoutDefault((JComponent)tablePane, 1, alwaysButton, this.makeOkButton("yes_later"), this.makeCancelButton("no_later"), neverButton);
    }

    @Override
    public void ok() {
        this.answer = 0;
        super.ok();
    }

    @Override
    public void cancel() {
        this.answer = 1;
        super.cancel();
    }

    public static void init() {
        UsageStatsTransmissionDialog.startTimer();
    }

    private static boolean askForTransmission() {
        String property = System.getProperty("rapidminer.gui.transfer_usagestats");
        if ("never".equals(property)) {
            return false;
        }
        if ("always".equals(property)) {
            return true;
        }
        UsageStatsTransmissionDialog trd = new UsageStatsTransmissionDialog();
        trd.setVisible(true);
        return trd.answer == 0;
    }

    private static void startTimer() {
        if (UsageStatistics.getInstance().hasFailedToday()) {
            return;
        }
        long timeToFire = UsageStatistics.getInstance().getNextTransmission().getTime() - System.currentTimeMillis();
        if (timeToFire < 0L) {
            timeToFire = 600000L;
        }
        Timer timer = new Timer((int)timeToFire, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UsageStatsTransmissionDialog.askForTransmission()) {
                    new ProgressThread("transmit_usagestats"){

                        @Override
                        public void run() {
                            this.getProgressListener().setTotal(100);
                            this.getProgressListener().setCompleted(10);
                            try {
                                if (UsageStatistics.getInstance().transferUsageStats(this.getProgressListener())) {
                                    UsageStatistics.getInstance().reset();
                                    UsageStatistics.getInstance().scheduleTransmission(false);
                                } else {
                                    UsageStatistics.getInstance().scheduleTransmission(true);
                                }
                            }
                            catch (Exception e) {
                                LogService.getRoot().log(Level.WARNING, "Error submitting operator usage statistics. Are you online?", e);
                                UsageStatistics.getInstance().scheduleTransmission(true);
                            }
                            this.getProgressListener().setCompleted(90);
                            UsageStatsTransmissionDialog.startTimer();
                            this.getProgressListener().setCompleted(100);
                            this.getProgressListener().complete();
                        }
                    }.start();
                } else {
                    UsageStatistics.getInstance().scheduleTransmissionFromNow();
                    UsageStatsTransmissionDialog.startTimer();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }
}

