/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.usagestats;

import com.rapid_i.rapidhome.wsimport.RapidHome;
import com.rapid_i.rapidhome.wsimport.RapidHomeService;
import com.rapid_i.rapidhome.wsimport.StatisticsRecord;
import com.rapid_i.rapidhome.wsimport.StatisticsReport;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.WebServiceTools;
import com.rapidminer.tools.usagestats.OperatorStatisticsDataTable;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.OperatorUsageStatistics;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.BindingProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UsageStatistics {
    private static final String[] RAPIDMINER_HOME_URLS = new String[]{"http://rapid1.de:80/RapidHome/RapidHomeService?wsdl", "http://rapid21.de:80/RapidHome/RapidHomeService?wsdl"};
    private static final long TRANSMISSION_INTERVAL = 1209600000L;
    private final EnumMap<StatisticsScope, Map<String, OperatorUsageStatistics>> statsMaps = new EnumMap(StatisticsScope.class);
    private Date lastReset;
    private Date nextTransmission;
    private static final UsageStatistics INSTANCE = new UsageStatistics();
    private String randomKey;
    private transient boolean failedToday = false;

    public static UsageStatistics getInstance() {
        return INSTANCE;
    }

    private UsageStatistics() {
        for (StatisticsScope t : StatisticsScope.values()) {
            this.statsMaps.put(t, new HashMap());
        }
        this.load();
    }

    private void load() {
        if (!RapidMiner.getExecutionMode().canAccessFilesystem()) {
            LogService.getRoot().config("Cannot access file system. Bypassing loading of operator usage statistics.");
            return;
        }
        File file = ParameterService.getUserConfigFile("usagestats.xml");
        if (file.exists()) {
            try {
                LogService.getRoot().config("Loading operator usage statistics.");
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                Element root = doc.getDocumentElement();
                String lastReset = root.getAttribute("last_reset");
                if (lastReset != null && !lastReset.isEmpty()) {
                    try {
                        this.lastReset = UsageStatistics.getDateFormat().parse(lastReset);
                    }
                    catch (ParseException e) {
                        this.lastReset = new Date();
                    }
                } else {
                    this.lastReset = new Date();
                }
                this.randomKey = root.getAttribute("random_key");
                if (this.randomKey == null || this.randomKey.isEmpty()) {
                    this.randomKey = this.createRandomKey();
                }
                String nextTransmission = root.getAttribute("next_transmission");
                if (lastReset != null && !lastReset.isEmpty()) {
                    try {
                        this.nextTransmission = UsageStatistics.getDateFormat().parse(nextTransmission);
                    }
                    catch (ParseException e) {
                        this.scheduleTransmission(true);
                    }
                } else {
                    this.scheduleTransmission(false);
                }
                for (StatisticsScope scope : StatisticsScope.values()) {
                    Element element = (Element)doc.getElementsByTagName(scope.getXMLTag()).item(0);
                    NodeList children = element.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        if (!(children.item(i) instanceof Element)) continue;
                        Element child = (Element)children.item(i);
                        this.getOperatorStatistics(scope, child.getTagName()).parse(child);
                    }
                }
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Cannot load usage statistics: " + e, e);
            }
        } else {
            this.randomKey = this.createRandomKey();
        }
    }

    private String createRandomKey() {
        StringBuilder randomKey = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 16; ++i) {
            randomKey.append((char)(65 + random.nextInt(26)));
        }
        return randomKey.toString();
    }

    public synchronized void reset() {
        this.getOperatorUsageStatistics(StatisticsScope.CURRENT).clear();
        this.lastReset = new Date();
    }

    public synchronized void count(Process process, OperatorStatisticsValue type) {
        this.count(process, type, StatisticsScope.values());
    }

    public void count(Process process, OperatorStatisticsValue type, StatisticsScope ... scopes) {
        List<Operator> allInnerOperators = process.getRootOperator().getAllInnerOperators();
        for (Operator op : allInnerOperators) {
            this.count(op, type, scopes);
        }
    }

    public void count(Operator op, OperatorStatisticsValue type) {
        this.count(op, type, StatisticsScope.values());
    }

    public void count(Operator op, OperatorStatisticsValue type, StatisticsScope ... scopes) {
        if (op != null) {
            this.count(op.getOperatorDescription().getKey(), type, scopes);
        }
    }

    private synchronized void count(String operatorKey, OperatorStatisticsValue type, StatisticsScope ... scopes) {
        for (StatisticsScope scope : scopes) {
            this.getOperatorStatistics(scope, operatorKey).count(type);
        }
    }

    public OperatorUsageStatistics getOperatorStatistics(StatisticsScope scope, OperatorDescription op) {
        return this.getOperatorStatistics(scope, op.getKey());
    }

    synchronized OperatorUsageStatistics getOperatorStatistics(StatisticsScope scope, String opKey) {
        OperatorUsageStatistics stats = this.getOperatorUsageStatistics(scope).get(opKey);
        if (stats == null) {
            stats = new OperatorUsageStatistics();
            this.getOperatorUsageStatistics(scope).put(opKey, stats);
        }
        return stats;
    }

    private Map<String, OperatorUsageStatistics> getOperatorUsageStatistics(StatisticsScope scope) {
        return this.statsMaps.get((Object)scope);
    }

    private Document getXML() {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Cannot create parser: " + e, e);
        }
        Element root = doc.createElement("usageStatistics");
        if (this.lastReset != null) {
            root.setAttribute("last_reset", UsageStatistics.getDateFormat().format(this.lastReset));
        }
        if (this.nextTransmission != null) {
            root.setAttribute("next_transmission", UsageStatistics.getDateFormat().format(this.nextTransmission));
        }
        root.setAttribute("random_key", this.randomKey);
        doc.appendChild(root);
        for (Map.Entry<StatisticsScope, Map<String, OperatorUsageStatistics>> entry : this.statsMaps.entrySet()) {
            Map<String, OperatorUsageStatistics> statsMap = entry.getValue();
            StatisticsScope scope = entry.getKey();
            Element current = doc.createElement(scope.getXMLTag());
            root.appendChild(current);
            for (Map.Entry<String, OperatorUsageStatistics> statsEntry : statsMap.entrySet()) {
                current.appendChild(statsEntry.getValue().getXML(statsEntry.getKey(), doc));
            }
        }
        return doc;
    }

    public void save() {
        if (RapidMiner.getExecutionMode().canAccessFilesystem()) {
            File file = ParameterService.getUserConfigFile("usagestats.xml");
            try {
                LogService.getRoot().config("Saving operator usage.");
                XMLTools.stream(this.getXML(), file, null);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Cannot save operator usage statistics: " + e, e);
            }
        } else {
            LogService.getRoot().config("Cannot access file system. Bypassing save of operator usage statistics.");
        }
    }

    public DataTable getAsDataTable(StatisticsScope scope) {
        return new OperatorStatisticsDataTable(this, scope);
    }

    public List<String> getOperatorKeys(StatisticsScope scope) {
        return new LinkedList<String>(this.getOperatorUsageStatistics(scope).keySet());
    }

    private static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(3, 3, Locale.US);
    }

    public boolean transferUsageStats(ProgressListener progressListener) throws Exception {
        RapidHome rapidHome;
        StatisticsReport report = new StatisticsReport();
        report.setFrom(XMLTools.getXMLGregorianCalendar(this.lastReset));
        report.setTo(XMLTools.getXMLGregorianCalendar(new Date()));
        report.setUserKey(this.randomKey);
        for (String name : this.getOperatorKeys(StatisticsScope.CURRENT)) {
            OperatorUsageStatistics stats = this.getOperatorStatistics(StatisticsScope.CURRENT, name);
            StatisticsRecord record = new StatisticsRecord();
            record.setOperatorName(name);
            record.setExecution(stats.getStatistics(OperatorStatisticsValue.EXECUTION));
            record.setFailure(stats.getStatistics(OperatorStatisticsValue.FAILURE));
            record.setOperatorException(stats.getStatistics(OperatorStatisticsValue.OPERATOR_EXCEPTION));
            record.setRuntimeError(stats.getStatistics(OperatorStatisticsValue.RUNTIME_EXCEPTION));
            record.setStop(stats.getStatistics(OperatorStatisticsValue.STOPPED));
            record.setUserError(stats.getStatistics(OperatorStatisticsValue.USER_ERROR));
            report.getRecords().add(record);
        }
        if (progressListener != null) {
            progressListener.setCompleted(25);
        }
        if ((rapidHome = this.getPort()) != null) {
            if (progressListener != null) {
                progressListener.setCompleted(40);
            }
            rapidHome.uploadUsageStatistics(report);
            if (progressListener != null) {
                progressListener.setCompleted(80);
            }
            return true;
        }
        if (progressListener != null) {
            progressListener.setCompleted(80);
        }
        return false;
    }

    private RapidHome getPort() {
        for (String urlString : RAPIDMINER_HOME_URLS) {
            try {
                URL url = new URL(urlString);
                LogService.getRoot().info("Transferring operator usage statistics to " + url + ".");
                RapidHomeService rapidHomeService = new RapidHomeService(url, new QName("http://ws.rapidhome.rapid_i.com/", "RapidHomeService"));
                RapidHome port = rapidHomeService.getRapidHomePort();
                WebServiceTools.setTimeout((BindingProvider)port);
                return port;
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to connect to usage statistics service " + urlString + ".", e);
            }
        }
        return null;
    }

    void scheduleTransmission(boolean lastAttemptFailed) {
        this.failedToday = true;
        this.nextTransmission = new Date(this.lastReset.getTime() + 1209600000L);
    }

    public Date getNextTransmission() {
        if (this.nextTransmission == null) {
            this.scheduleTransmissionFromNow();
        }
        return this.nextTransmission;
    }

    public void scheduleTransmissionFromNow() {
        this.nextTransmission = new Date(System.currentTimeMillis() + 1209600000L);
    }

    public boolean hasFailedToday() {
        return this.failedToday;
    }

    public static void main(String[] args) {
        UsageStatistics.getInstance().getPort();
    }

    public static enum StatisticsScope {
        CURRENT("current"),
        ALL_TIME("allTime");

        private String xmlTag;

        private StatisticsScope(String xmlTag) {
            this.xmlTag = xmlTag;
        }

        protected String getXMLTag() {
            return this.xmlTag;
        }
    }
}

