/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.usagestats;

import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import java.util.EnumMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OperatorUsageStatistics {
    private final EnumMap<OperatorStatisticsValue, Integer> statistics = new EnumMap(OperatorStatisticsValue.class);

    protected void parse(Element element) {
        for (OperatorStatisticsValue type : OperatorStatisticsValue.values()) {
            String stats = XMLTools.getTagContents(element, type.getTagName());
            if (stats == null) continue;
            this.statistics.put(type, Integer.parseInt(stats));
        }
    }

    public void reset() {
        this.statistics.clear();
    }

    protected void count(OperatorStatisticsValue type) {
        Integer value = this.statistics.get((Object)type);
        value = value == null ? Integer.valueOf(1) : Integer.valueOf(value + 1);
        this.statistics.put(type, value);
    }

    protected Node getXML(String key, Document doc) {
        Element element = doc.createElement(key);
        this.mapToXML(element, this.statistics);
        return element;
    }

    private void mapToXML(Element element, EnumMap<OperatorStatisticsValue, Integer> map) {
        for (Map.Entry<OperatorStatisticsValue, Integer> entry : map.entrySet()) {
            XMLTools.setTagContents(element, entry.getKey().getTagName(), entry.getValue().toString());
        }
    }

    public int getStatistics(OperatorStatisticsValue type) {
        Integer val = this.statistics.get((Object)type);
        if (val == null) {
            return 0;
        }
        return val;
    }
}

