/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.usagestats;

import com.rapidminer.datatable.AbstractDataTable;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class OperatorStatisticsDataTable
extends AbstractDataTable {
    private final UsageStatistics usageStatistics;
    private final UsageStatistics.StatisticsScope scope;
    private final List<String> operatorKeys;

    OperatorStatisticsDataTable(UsageStatistics usageStatistics, UsageStatistics.StatisticsScope scope) {
        super("Operator Statistics for " + (Object)((Object)scope));
        this.usageStatistics = usageStatistics;
        this.scope = scope;
        this.operatorKeys = new ArrayList<String>(usageStatistics.getOperatorKeys(scope));
    }

    @Override
    public void add(DataTableRow row) {
        throw new UnsupportedOperationException("Statistics table is immutable");
    }

    @Override
    public int getColumnIndex(String name) {
        if ("Operator".equals(name)) {
            return 0;
        }
        for (OperatorStatisticsValue type : OperatorStatisticsValue.values()) {
            if (!type.toString().equals(name)) continue;
            return type.ordinal();
        }
        return -1;
    }

    @Override
    public String getColumnName(int i) {
        if (i == 0) {
            return "Operator";
        }
        return OperatorStatisticsValue.values()[i - 1].toString();
    }

    @Override
    public double getColumnWeight(int i) {
        return 1.0;
    }

    @Override
    public int getNumberOfColumns() {
        return OperatorStatisticsValue.values().length + 1;
    }

    @Override
    public int getNumberOfRows() {
        return this.operatorKeys.size();
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return 0;
    }

    @Override
    public int getNumberOfValues(int column) {
        if (column == 0) {
            return this.operatorKeys.size();
        }
        return -1;
    }

    @Override
    public DataTableRow getRow(final int row) {
        return new DataTableRow(){

            @Override
            public String getId() {
                return "" + row;
            }

            @Override
            public int getNumberOfValues() {
                return OperatorStatisticsValue.values().length;
            }

            @Override
            public double getValue(int col) {
                if (col == 0) {
                    return row;
                }
                OperatorStatisticsValue colType = OperatorStatisticsValue.values()[col - 1];
                String opKey = (String)OperatorStatisticsDataTable.this.operatorKeys.get(row);
                return OperatorStatisticsDataTable.this.usageStatistics.getOperatorStatistics(OperatorStatisticsDataTable.this.scope, opKey).getStatistics(colType);
            }
        };
    }

    @Override
    public boolean isDate(int index) {
        return false;
    }

    @Override
    public boolean isDateTime(int index) {
        return false;
    }

    @Override
    public boolean isNominal(int index) {
        return index == 0;
    }

    @Override
    public boolean isNumerical(int index) {
        return index != 0;
    }

    @Override
    public boolean isSpecial(int column) {
        return false;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return false;
    }

    @Override
    public boolean isTime(int index) {
        return false;
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new Iterator<DataTableRow>(){
            private int row;

            @Override
            public boolean hasNext() {
                return this.row < OperatorStatisticsDataTable.this.operatorKeys.size();
            }

            @Override
            public DataTableRow next() {
                return OperatorStatisticsDataTable.this.getRow(this.row++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing statistics is not supported.");
            }
        };
    }

    @Override
    public String mapIndex(int column, int index) {
        if (column == 0) {
            String key = this.operatorKeys.get(index);
            OperatorDescription desc = OperatorService.getOperatorDescription(key);
            if (desc != null) {
                return desc.getName();
            }
            return key;
        }
        return "" + index;
    }

    @Override
    public int mapString(int column, String value) {
        if (column == 0) {
            return this.operatorKeys.indexOf(value);
        }
        return -1;
    }

    @Override
    public DataTable sample(int newSize) {
        throw new UnsupportedOperationException("Sampling not supported for statistics tables.");
    }
}

