/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.plugin;

import com.rapid_i.deployment.update.client.ManagedExtension;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.flow.ProcessRenderer;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.tools.SplashScreen;
import com.rapidminer.gui.tools.dialogs.AboutBox;
import com.rapidminer.io.Base64;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ResourceSource;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.AllPluginsClassLoader;
import com.rapidminer.tools.plugin.Dependency;
import com.rapidminer.tools.plugin.PluginClassLoader;
import com.rapidminer.tools.plugin.PluginException;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Plugin {
    public static final String RAPIDMINER_TYPE = "RapidMiner-Type";
    public static final String RAPIDMINER_TYPE_PLUGIN = "RapidMiner_Extension";
    private static final ClassLoader MAJOR_CLASS_LOADER;
    private final JarFile archive;
    private final File file;
    private PluginClassLoader classLoader;
    private String name;
    private String version;
    private String vendor;
    private String url;
    private String necessaryRapidMinerVersion = "0";
    private final List<Dependency> pluginDependencies = new LinkedList<Dependency>();
    private String extensionId;
    private String pluginInitClassName;
    private String pluginResourceObjects;
    private String pluginResourceOperators;
    private String pluginParseRules;
    private String pluginGroupDescriptions;
    private String pluginErrorDescriptions;
    private String pluginUserErrorDescriptions;
    private String pluginGUIDescriptions;
    private String prefix;
    private boolean disabled = false;
    private static final List<Plugin> allPlugins;

    public Plugin(File file) throws IOException {
        this.file = file;
        this.archive = new JarFile(this.file);
        this.classLoader = this.makeNonDelegatingClassloader();
        Tools.addResourceSource(new ResourceSource(this.classLoader));
        this.fetchMetaData();
        if (!RapidMiner.getExecutionMode().isHeadless()) {
            RapidMiner.getSplashScreen().addExtension(this);
        }
    }

    private PluginClassLoader makeNonDelegatingClassloader() {
        URL url;
        try {
            url = this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot make classloader for plugin: " + e, e);
        }
        PluginClassLoader cl = new PluginClassLoader(new URL[]{url});
        return cl;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNecessaryRapidMinerVersion() {
        return this.necessaryRapidMinerVersion;
    }

    public String getPluginInitClassName() {
        return this.pluginInitClassName;
    }

    public String getPluginParseRules() {
        return this.pluginParseRules;
    }

    public String getPluginGroupDescriptions() {
        return this.pluginGroupDescriptions;
    }

    public String getPluginErrorDescriptions() {
        return this.pluginErrorDescriptions;
    }

    public String getPluginUserErrorDescriptions() {
        return this.pluginUserErrorDescriptions;
    }

    public String getPluginGUIDescriptions() {
        return this.pluginGUIDescriptions;
    }

    public String getPluginResourceOperators() {
        return this.pluginResourceOperators;
    }

    public String getPluginResourceObjects() {
        return this.pluginResourceObjects;
    }

    public List getPluginDependencies() {
        return this.pluginDependencies;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getOriginalClassLoader() {
        try {
            final URL url = new URL("file", null, this.file.getAbsolutePath());
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    return new URLClassLoader(new URL[]{url}, Plugin.class.getClassLoader());
                }
            });
        }
        catch (IOException e) {
            return null;
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }

    private boolean checkDependencies(List plugins) {
        if (RapidMiner.getLongVersion().compareTo(this.necessaryRapidMinerVersion) < 0) {
            return false;
        }
        if (this.pluginDependencies.size() > 1) {
            throw new UnsupportedOperationException("Only one dependent plugin allowed!");
        }
        for (Dependency dependency : this.pluginDependencies) {
            if (dependency.isFulfilled(plugins)) continue;
            return false;
        }
        return true;
    }

    private void fetchMetaData() {
        try {
            String dependencies;
            Attributes atts = this.archive.getManifest().getMainAttributes();
            this.name = this.getValue(atts, "Implementation-Title");
            if (this.name == null) {
                this.name = this.archive.getName();
            }
            this.version = this.getValue(atts, "Implementation-Version");
            if (this.version == null) {
                this.version = "";
            }
            this.url = this.getValue(atts, "Implementation-URL");
            this.vendor = this.getValue(atts, "Implementation-Vendor");
            this.prefix = this.getValue(atts, "Namespace");
            this.extensionId = this.getValue(atts, "Extension-ID");
            this.pluginInitClassName = this.getValue(atts, "Initialization-Class");
            this.pluginResourceObjects = this.getDescriptorResource("IOObject-Descriptor", false, false, atts);
            this.pluginResourceOperators = this.getDescriptorResource("Operator-Descriptor", false, true, atts);
            this.pluginParseRules = this.getDescriptorResource("ParseRule-Descriptor", false, false, atts);
            this.pluginGroupDescriptions = this.getDescriptorResource("Group-Descriptor", false, false, atts);
            this.pluginErrorDescriptions = this.getDescriptorResource("Error-Descriptor", false, true, atts);
            this.pluginUserErrorDescriptions = this.getDescriptorResource("UserError-Descriptor", false, true, atts);
            this.pluginGUIDescriptions = this.getDescriptorResource("GUI-Descriptor", false, true, atts);
            this.necessaryRapidMinerVersion = this.getValue(atts, "RapidMiner-Version");
            if (this.necessaryRapidMinerVersion == null) {
                this.necessaryRapidMinerVersion = "0";
            }
            if ((dependencies = this.getValue(atts, "Plugin-Dependencies")) == null) {
                dependencies = "";
            }
            this.addDependencies(dependencies);
            RapidMiner.splashMessage("loading_plugin", this.name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getValue(Attributes atts, String key) {
        String result = atts.getValue(key);
        if (result == null) {
            return null;
        }
        if ((result = result.trim()).isEmpty()) {
            return null;
        }
        return result;
    }

    private String getDescriptorResource(String typeName, boolean mandatory, boolean isBundle, Attributes atts) throws IOException {
        String value = this.getValue(atts, typeName);
        if (value == null) {
            if (mandatory) {
                throw new IOException("Manifest attribute '" + typeName + "' is not defined.");
            }
            return null;
        }
        if (isBundle) {
            return this.toResourceBundleIdentifier(value);
        }
        return this.toResourceIdentifier(value);
    }

    private String toResourceBundleIdentifier(String value) {
        if (value.startsWith("/")) {
            value = value.substring(1);
        }
        if (value.endsWith(".properties")) {
            value = value.substring(0, value.length() - 11);
        }
        return value;
    }

    private String toResourceIdentifier(String value) {
        if (value.startsWith("/")) {
            value = value.substring(1);
        }
        return value;
    }

    private void addDependencies(String dependencies) {
        this.pluginDependencies.addAll(Dependency.parse(dependencies));
    }

    public void registerOperators() {
        if (this.disabled) {
            LogService.getRoot().warning("Plugin " + this.getName() + " disabled due to previous errors. Not registering operators.");
        }
        InputStream in = null;
        if (this.pluginResourceOperators != null) {
            URL operatorsURL = this.classLoader.getResource(this.pluginResourceOperators);
            if (operatorsURL == null) {
                LogService.getRoot().log(Level.WARNING, "Operator descriptor '" + this.pluginResourceOperators + "' does not exist in '" + this.archive.getName() + "'!");
                return;
            }
            try {
                in = operatorsURL.openStream();
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot read operator descriptor '" + operatorsURL + "' from '" + this.archive.getName() + "'!", e);
                return;
            }
        }
        if (this.pluginInitClassName != null) {
            LogService.getRoot().info("No operator descriptor specified for plugin " + this.getName() + ". Trying plugin initializtation class " + this.pluginInitClassName + ".");
            try {
                Class<?> pluginInitator = Class.forName(this.pluginInitClassName, false, this.getClassLoader());
                Method registerOperatorMethod = pluginInitator.getMethod("getOperatorStream", ClassLoader.class);
                in = (InputStream)registerOperatorMethod.invoke(null, this.getClassLoader());
            }
            catch (ClassNotFoundException e) {
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (in != null) {
            Iterator<Dependency> i = this.pluginDependencies.iterator();
            while (i.hasNext()) {
                String pluginName = i.next().getPluginExtensionId();
                final Plugin other = Plugin.getPluginByExtensionId(pluginName);
                this.classLoader = AccessController.doPrivileged(new PrivilegedAction<PluginClassLoader>(){

                    @Override
                    public PluginClassLoader run() {
                        return new PluginClassLoader(Plugin.this.classLoader.getURLs(), other);
                    }
                });
            }
            OperatorService.registerOperators(this.archive.getName(), in, this.classLoader, this);
        } else {
            LogService.getRoot().warning("No operator descriptor defined for: " + this.getName());
        }
    }

    public void registerDescriptions() throws PluginException {
        URL resource;
        if (this.pluginErrorDescriptions != null) {
            I18N.registerErrorBundle(ResourceBundle.getBundle(this.pluginErrorDescriptions, Locale.getDefault(), this.classLoader));
        }
        if (this.pluginGUIDescriptions != null) {
            I18N.registerGUIBundle(ResourceBundle.getBundle(this.pluginGUIDescriptions, Locale.getDefault(), this.classLoader));
        }
        if (this.pluginUserErrorDescriptions != null) {
            I18N.registerUserErrorMessagesBundle(ResourceBundle.getBundle(this.pluginUserErrorDescriptions, Locale.getDefault(), this.classLoader));
        }
        if (this.pluginResourceObjects != null) {
            resource = this.classLoader.getResource(this.pluginResourceObjects);
            if (resource != null) {
                RendererService.init(this.name, resource, (ClassLoader)this.classLoader);
            } else {
                throw new PluginException("Cannot find io object descriptor '" + this.pluginResourceObjects + "' for plugin " + this.getName() + ".");
            }
        }
        if (this.pluginParseRules != null) {
            resource = this.classLoader.getResource(this.pluginParseRules);
            if (resource != null) {
                XMLImporter.importParseRules(resource, this);
            } else {
                throw new PluginException("Cannot find parse rules '" + this.pluginParseRules + "' for plugin " + this.getName() + ".");
            }
        }
        if (this.pluginGroupDescriptions != null) {
            ProcessRenderer.registerAdditionalObjectColors(this.pluginGroupDescriptions, this.name, this.classLoader);
            ProcessRenderer.registerAdditionalGroupColors(this.pluginGroupDescriptions, this.name, this.classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildingBlock> getBuildingBlocks() {
        URL bbDefinition;
        LinkedList<BuildingBlock> result = new LinkedList<BuildingBlock>();
        URL url = null;
        try {
            url = new URL("file", null, this.file.getAbsolutePath());
        }
        catch (MalformedURLException e1) {
            LogService.getRoot().log(Level.WARNING, "Cannot load plugin building blocks. Skipping...", e1);
        }
        if (url != null && (bbDefinition = this.classLoader.getResource("com/rapidminer/resources/buildingblocks.txt")) != null) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(bbDefinition.openStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    URL bbURL = this.classLoader.getResource("com/rapidminer/resources/" + line);
                    BufferedReader bbIn = null;
                    try {
                        bbIn = new BufferedReader(new InputStreamReader(bbURL.openStream()));
                        result.add(new BuildingBlock(bbIn, 3));
                    }
                    catch (IOException e) {
                        LogService.getRoot().log(Level.WARNING, "Cannot load plugin building blocks. Skipping...", e);
                    }
                    finally {
                        if (bbIn == null) continue;
                        bbIn.close();
                    }
                }
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot load plugin building blocks.", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LogService.getRoot().log(Level.WARNING, "Cannot close stream to plugin building blocks.", e);
                    }
                }
            }
        }
        return result;
    }

    public AboutBox createAboutBox(Frame owner) {
        PluginClassLoader simpleClassLoader = this.makeNonDelegatingClassloader();
        String about = "";
        try {
            URL url = simpleClassLoader.getResource("META-INF/ABOUT.NFO");
            if (url != null) {
                about = Tools.readTextFile(new InputStreamReader(url.openStream()));
            }
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Error reading ABOUT.NFO for plugin " + this.getName(), e);
        }
        BufferedImage productLogo = null;
        try {
            InputStream imageIn = ((ClassLoader)simpleClassLoader).getResourceAsStream("META-INF/icon.png");
            productLogo = ImageIO.read(imageIn);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Error reading icon.png for plugin " + this.getName(), e);
        }
        return new AboutBox(owner, this.name, this.version, "Vendor: " + (this.vendor != null ? this.vendor : "unknown"), this.url, about, true, productLogo);
    }

    private static void findAndRegisterPlugins(File pluginDir, boolean showWarningForNonPluginJars) {
        LinkedList<File> files = new LinkedList<File>();
        if (pluginDir == null) {
            LogService.getRoot().warning("findAndRegisterPlugins called with null directory.");
            return;
        }
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            LogService.getRoot().config("Plugin directory " + pluginDir + " does not exist.");
        } else {
            LogService.getRoot().config("Scanning plugins in " + pluginDir + ".");
            files.addAll(Arrays.asList(pluginDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })));
        }
        Plugin.registerPlugins(files, showWarningForNonPluginJars);
    }

    private static void registerPlugins(List<File> files, boolean showWarningForNonPluginJars) {
        for (File file : files) {
            try {
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                if (RAPIDMINER_TYPE_PLUGIN.equals(attributes.getValue(RAPIDMINER_TYPE))) {
                    Plugin plugin = new Plugin(file);
                    Plugin conflict = Plugin.getPluginByExtensionId(plugin.getExtensionId());
                    if (conflict == null) {
                        allPlugins.add(plugin);
                        continue;
                    }
                    LogService.getRoot().warning("Duplicate plugin definition for plugin " + plugin.getExtensionId() + " in " + conflict.file + " and " + file + ". Keeping the first.");
                    continue;
                }
                if (!showWarningForNonPluginJars) continue;
                LogService.getRoot().warning("The jar file '" + jarFile.getName() + "' does not contain an entry '" + RAPIDMINER_TYPE + "' in its manifest and will therefore not be loaded (if this file actually is a plugin updating the plugin file might help).");
            }
            catch (Throwable e) {
                LogService.getRoot().log(Level.WARNING, "Cannot load plugin '" + file + "': " + e.getMessage(), e);
            }
        }
    }

    public String toString() {
        return this.name + " " + this.version + " (" + this.archive.getName() + ") depending on " + this.pluginDependencies;
    }

    private static void registerAllPluginDescriptions() {
        Plugin plugin;
        Iterator<Plugin> i = allPlugins.iterator();
        while (i.hasNext()) {
            plugin = i.next();
            if (plugin.checkDependencies(allPlugins)) continue;
            LogService.getRoot().warning("Cannot register operators from '" + plugin.getName() + "': Dependencies not fulfilled! This plugin needs a RapidMiner version " + plugin.getNecessaryRapidMinerVersion() + " and the following plugins:" + Tools.getLineSeparator() + plugin.getPluginDependencies());
            plugin.disabled = true;
            i.remove();
        }
        if (allPlugins.size() > 0) {
            i = allPlugins.iterator();
            while (i.hasNext()) {
                plugin = i.next();
                try {
                    plugin.registerDescriptions();
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Error initializing plugin: " + e, e);
                    i.remove();
                    plugin.disabled = true;
                }
            }
        }
    }

    public static void registerAllPluginOperators() {
        for (Plugin plugin : allPlugins) {
            plugin.registerOperators();
        }
    }

    public static ClassLoader getMajorClassLoader() {
        return MAJOR_CLASS_LOADER;
    }

    public static List<Plugin> getAllPlugins() {
        return allPlugins;
    }

    public static Plugin getPluginByExtensionId(String name) {
        for (Plugin plugin : allPlugins) {
            if (!name.equals(plugin.getExtensionId())) continue;
            return plugin;
        }
        return null;
    }

    public static void initPluginGuis(MainFrame mainframe) {
        Plugin.callPluginInitMethods("initGui", new Class[]{MainFrame.class}, new Object[]{mainframe}, false);
    }

    public static void initPlugins() {
        Plugin.callPluginInitMethods("initPlugin", new Class[0], new Object[0], true);
    }

    public static void initPluginUpdateManager() {
        Plugin.callPluginInitMethods("initPluginManager", new Class[0], new Object[0], false);
    }

    public static void initFinalChecks() {
        Plugin.callPluginInitMethods("initFinalChecks", new Class[0], new Object[0], false);
    }

    private static void callPluginInitMethods(String methodName, Class[] arguments, Object[] argumentValues, boolean useOriginalJarClassLoader) {
        List<Plugin> plugins = Plugin.getAllPlugins();
        for (Plugin plugin : plugins) {
            plugin.callInitMethod(methodName, arguments, argumentValues, useOriginalJarClassLoader);
        }
    }

    private void callInitMethod(String methodName, Class[] arguments, Object[] argumentValues, boolean useOriginalJarClassLoader) {
        if (this.pluginInitClassName == null) {
            return;
        }
        try {
            Method initMethod;
            ClassLoader classLoader = useOriginalJarClassLoader ? this.getOriginalClassLoader() : this.getClassLoader();
            Class<?> pluginInitator = Class.forName(this.pluginInitClassName, false, classLoader);
            try {
                initMethod = pluginInitator.getMethod(methodName, arguments);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            initMethod.invoke(null, argumentValues);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Plugin initializer " + this.pluginInitClassName + "." + methodName + " of Plugin " + this.getName() + " causes an error: " + e.getMessage(), e);
        }
    }

    public static void initPluginSplashTexts(SplashScreen splashScreen) {
        Plugin.callPluginInitMethods("initSplashTexts", new Class[]{SplashScreen.class}, new Object[]{splashScreen}, false);
    }

    public static void initAboutTexts(Properties properties) {
        Plugin.callPluginInitMethods("initAboutTexts", new Class[]{Properties.class}, new Object[]{properties}, false);
    }

    public boolean showAboutBox() {
        if (this.pluginInitClassName == null) {
            return true;
        }
        try {
            Class<?> pluginInitator = Class.forName(this.pluginInitClassName, false, this.getOriginalClassLoader());
            Method initGuiMethod = pluginInitator.getMethod("showAboutBox", new Class[0]);
            Boolean showAboutBox = (Boolean)initGuiMethod.invoke(null, new Object[0]);
            return showAboutBox;
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return true;
    }

    public static void initAll() {
        String loadPluginsString;
        boolean loadPlugins;
        if (RapidMiner.getExecutionMode().isLoadingManagedExtensions()) {
            ManagedExtension.init();
        }
        if (loadPlugins = Tools.booleanValue(loadPluginsString = System.getProperty("rapidminer.init.plugins"), true)) {
            File webstartPluginDir = RapidMiner.getExecutionMode() == RapidMiner.ExecutionMode.WEBSTART ? Plugin.updateWebstartPluginsCache() : null;
            File pluginDir = null;
            String pluginDirString = System.getProperty("rapidminer.init.plugins.location");
            if (pluginDirString != null && !pluginDirString.isEmpty()) {
                pluginDir = new File(pluginDirString);
            }
            if (pluginDir == null) {
                try {
                    pluginDir = Plugin.getPluginLocation();
                }
                catch (IOException e) {
                    LogService.getRoot().warning("None of the properties rapidminer.init.plugins and rapidminer.home is set. No globally installed plugins will be loaded.");
                }
            }
            if (webstartPluginDir != null) {
                Plugin.findAndRegisterPlugins(webstartPluginDir, true);
            }
            if (pluginDir != null) {
                Plugin.findAndRegisterPlugins(pluginDir, true);
            }
            Plugin.registerPlugins(ManagedExtension.getActivePluginJars(), true);
            Plugin.registerAllPluginDescriptions();
            Plugin.initPlugins();
        } else {
            LogService.getRoot().config("Plugins skipped.");
        }
    }

    private static File updateWebstartPluginsCache() {
        Document pluginsDoc;
        String dirName;
        String homeUrl = System.getProperty("rapidminer.homerepository.url");
        try {
            byte[] md5hash = MessageDigest.getInstance("MD5").digest(homeUrl.getBytes());
            dirName = Base64.encodeBytes(md5hash);
        }
        catch (NoSuchAlgorithmException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to hash remote url: " + e, e);
            return null;
        }
        File cacheDir = new File(ManagedExtension.getUserExtensionsDir(), dirName);
        cacheDir.mkdirs();
        File readmeFile = new File(cacheDir, "README.txt");
        try {
            Tools.writeTextFile(readmeFile, "This directory contains plugins downloaded from RapidAnalytics instance \n  " + homeUrl + ".\n" + "These plugins are only used if RapidMiner is started via WebStart from this \n" + "server. You can delete the directory if you no longer need the cached plugins.");
        }
        catch (IOException e1) {
            LogService.getRoot().log(Level.WARNING, "Failed to create file " + readmeFile + ": " + e1, e1);
        }
        try {
            URL pluginsListUrl = new URL(homeUrl + "/RAWS/dependencies/resources.xml");
            pluginsDoc = XMLTools.parse(pluginsListUrl.openStream());
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to load extensions list from server: " + e, e);
            return null;
        }
        HashSet<File> cachedFiles = new HashSet<File>();
        NodeList pluginElements = pluginsDoc.getElementsByTagName("extension");
        boolean errorOccurred = false;
        for (int i = 0; i < pluginElements.getLength(); ++i) {
            Element pluginElem = (Element)pluginElements.item(i);
            String pluginName = pluginElem.getTextContent();
            String pluginVersion = pluginElem.getAttribute("version");
            File pluginFile = new File(cacheDir, pluginName + "-" + pluginVersion + ".jar");
            cachedFiles.add(pluginFile);
            if (pluginFile.exists()) {
                LogService.getRoot().log(Level.CONFIG, "Found extension on server: " + pluginName + ". Local cache exists.");
                continue;
            }
            LogService.getRoot().log(Level.CONFIG, "Found extension on server: " + pluginName + ". Downloading to local cache.");
            try {
                URL pluginUrl = new URL(homeUrl + "/RAWS/dependencies/plugins/" + pluginName);
                Tools.copyStreamSynchronously(pluginUrl.openStream(), new FileOutputStream(pluginFile), true);
                continue;
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to download extension from server: " + e, e);
                errorOccurred = true;
            }
        }
        if (!errorOccurred) {
            for (File file : cacheDir.listFiles()) {
                if (file.getName().equals("README.txt") || cachedFiles.contains(file)) continue;
                LogService.getRoot().log(Level.CONFIG, "Deleting obsolete file " + file + " from extension cache.");
                file.delete();
            }
        }
        return cacheDir;
    }

    public static void setInitPlugins(boolean init) {
        System.setProperty("rapidminer.init.plugins", Boolean.toString(init));
    }

    public static void setPluginLocation(String directory) {
        System.setProperty("rapidminer.init.plugins.location", directory);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public JarFile getArchive() {
        return this.archive;
    }

    public File getFile() {
        return this.file;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public static File getPluginLocation() throws IOException {
        String locationProperty = System.getProperty("rapidminer.init.plugins.location");
        if (locationProperty == null) {
            return ParameterService.getLibraryFile("plugins");
        }
        return new File(locationProperty);
    }

    public ImageIcon getExtensionIcon() {
        URL iconURL = this.classLoader.findResource("META-INF/icon.png");
        if (iconURL != null) {
            return new ImageIcon(iconURL);
        }
        return null;
    }

    static {
        try {
            MAJOR_CLASS_LOADER = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    return new AllPluginsClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Cannot create major class loader: " + e.getMessage(), e);
        }
        allPlugins = new LinkedList<Plugin>();
    }
}

