/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.plugin;

import com.rapid_i.deployment.update.client.ManagedExtension;
import com.rapidminer.tools.plugin.Plugin;
import java.util.LinkedList;
import java.util.List;

public class Dependency {
    private String extensionId;
    private String version;

    public Dependency(String name, String version) {
        this.extensionId = name;
        this.version = version;
    }

    public boolean isFulfilled(List plugins) {
        for (Plugin plugin : plugins) {
            if (!plugin.getExtensionId().equals(this.extensionId) || ManagedExtension.normalizeVersion(plugin.getVersion()).compareTo(ManagedExtension.normalizeVersion(this.version)) < 0) continue;
            return true;
        }
        return false;
    }

    public String getPluginExtensionId() {
        return this.extensionId;
    }

    public String getPluginVersion() {
        return this.version;
    }

    public String toString() {
        return this.extensionId + " (" + this.version + ")";
    }

    public static List<Dependency> parse(String dependencyString) {
        LinkedList<Dependency> result = new LinkedList<Dependency>();
        String[] singleDependencies = dependencyString.trim().split(";");
        for (int i = 0; i < singleDependencies.length; ++i) {
            if (singleDependencies[i].trim().length() <= 0) continue;
            String dependencyName = singleDependencies[i].trim();
            String dependencyVersion = "0";
            if (singleDependencies[i].trim().indexOf("[") >= 0) {
                dependencyName = singleDependencies[i].trim().substring(0, singleDependencies[i].trim().indexOf("[")).trim();
                dependencyVersion = singleDependencies[i].trim().substring(singleDependencies[i].trim().indexOf("[") + 1, singleDependencies[i].trim().indexOf("]")).trim();
            }
            result.add(new Dependency(dependencyName, dependencyVersion));
        }
        return result;
    }
}

